/*
 * Decompiled with CFR 0.152.
 */
package proguard;

import java.util.List;
import proguard.ClassSpecification;
import proguard.ClassSpecificationVisitorFactory;
import proguard.KeepClassSpecification;
import proguard.classfile.attribute.visitor.AttributeNameFilter;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.visitor.ClassPoolVisitor;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.MemberDescriptorReferencedClassVisitor;
import proguard.classfile.visitor.MemberVisitor;
import proguard.classfile.visitor.MultiClassPoolVisitor;
import proguard.classfile.visitor.MultiClassVisitor;
import proguard.classfile.visitor.MultiMemberVisitor;
import proguard.util.WildcardManager;

public class KeepClassSpecificationVisitorFactory
extends ClassSpecificationVisitorFactory {
    private final boolean shrinking;
    private final boolean optimizing;
    private final boolean obfuscating;

    public KeepClassSpecificationVisitorFactory(boolean shrinking, boolean optimizing, boolean obfuscating) {
        this.shrinking = shrinking;
        this.optimizing = optimizing;
        this.obfuscating = obfuscating;
    }

    @Override
    public ClassPoolVisitor createClassPoolVisitor(List keepClassSpecifications, ClassVisitor classVisitor, MemberVisitor fieldVisitor, MemberVisitor methodVisitor, AttributeVisitor attributeVisitor) {
        MultiClassPoolVisitor multiClassPoolVisitor = new MultiClassPoolVisitor();
        if (keepClassSpecifications != null) {
            for (int index = 0; index < keepClassSpecifications.size(); ++index) {
                KeepClassSpecification keepClassSpecification = (KeepClassSpecification)keepClassSpecifications.get(index);
                if (!(this.shrinking && !keepClassSpecification.allowShrinking || this.optimizing && !keepClassSpecification.allowOptimization) && (!this.obfuscating || keepClassSpecification.allowObfuscation)) continue;
                multiClassPoolVisitor.addClassPoolVisitor(this.createClassPoolVisitor(keepClassSpecification, classVisitor, fieldVisitor, methodVisitor, attributeVisitor));
            }
        }
        return multiClassPoolVisitor;
    }

    public ClassPoolVisitor createClassPoolVisitor(KeepClassSpecification keepClassSpecification, ClassVisitor classVisitor, MemberVisitor fieldVisitor, MemberVisitor methodVisitor, AttributeVisitor attributeVisitor) {
        ClassSpecification condition;
        WildcardManager wildcardManager = new WildcardManager();
        if (keepClassSpecification.markDescriptorClasses && classVisitor != null) {
            fieldVisitor = fieldVisitor == null ? new MemberDescriptorReferencedClassVisitor(classVisitor) : new MultiMemberVisitor(new MemberVisitor[]{fieldVisitor, new MemberDescriptorReferencedClassVisitor(classVisitor)});
            Object object = methodVisitor = methodVisitor == null ? new MemberDescriptorReferencedClassVisitor(true, classVisitor) : new MultiMemberVisitor(new MemberVisitor[]{methodVisitor, new MemberDescriptorReferencedClassVisitor(true, classVisitor)});
        }
        if (!keepClassSpecification.markClasses && !keepClassSpecification.markConditionally) {
            classVisitor = null;
        }
        if (attributeVisitor != null) {
            AttributeNameFilter attributeNameFilter = attributeVisitor = keepClassSpecification.markCodeAttributes ? new AttributeNameFilter("Code", attributeVisitor) : null;
        }
        if ((condition = keepClassSpecification.condition) != null) {
            MultiClassPoolVisitor keepClassPoolVisitor = new MultiClassPoolVisitor();
            ClassPoolVisitor conditionalKeepClassPoolVisitor = this.createClassTester(condition, (ClassPoolVisitor)keepClassPoolVisitor, wildcardManager);
            keepClassPoolVisitor.addClassPoolVisitor(this.createClassPoolVisitor(keepClassSpecification, classVisitor, fieldVisitor, methodVisitor, attributeVisitor, wildcardManager));
            return conditionalKeepClassPoolVisitor;
        }
        return this.createClassPoolVisitor(keepClassSpecification, classVisitor, fieldVisitor, methodVisitor, attributeVisitor, wildcardManager);
    }

    private ClassPoolVisitor createClassPoolVisitor(KeepClassSpecification keepClassSpecification, ClassVisitor classVisitor, MemberVisitor fieldVisitor, MemberVisitor methodVisitor, AttributeVisitor attributeVisitor, WildcardManager wildcardManager) {
        if (keepClassSpecification.markConditionally) {
            MultiClassVisitor keepClassVisitor = new MultiClassVisitor();
            ClassPoolVisitor conditionalKeepClassPoolVisitor = this.createClassTester((ClassSpecification)keepClassSpecification, (ClassVisitor)keepClassVisitor, new WildcardManager(wildcardManager));
            keepClassVisitor.addClassVisitor(this.createCombinedClassVisitor(keepClassSpecification.attributeNames, keepClassSpecification.fieldSpecifications, keepClassSpecification.methodSpecifications, classVisitor, fieldVisitor, methodVisitor, attributeVisitor, wildcardManager));
            return conditionalKeepClassPoolVisitor;
        }
        return super.createClassPoolVisitor(keepClassSpecification, classVisitor, fieldVisitor, methodVisitor, attributeVisitor, wildcardManager);
    }
}

