/*
 * Decompiled with CFR 0.152.
 */
package proguard.util.kotlin.asserter;

import java.io.PrintWriter;
import java.util.Arrays;
import java.util.List;
import proguard.AppView;
import proguard.Configuration;
import proguard.classfile.ClassPool;
import proguard.classfile.Clazz;
import proguard.classfile.kotlin.KotlinMetadata;
import proguard.classfile.kotlin.visitor.KotlinMetadataRemover;
import proguard.classfile.kotlin.visitor.KotlinMetadataVisitor;
import proguard.classfile.kotlin.visitor.ReferencedKotlinMetadataVisitor;
import proguard.classfile.util.WarningPrinter;
import proguard.classfile.visitor.ClassVisitor;
import proguard.pass.Pass;
import proguard.resources.file.ResourceFile;
import proguard.resources.file.visitor.ResourceFileProcessingFlagFilter;
import proguard.resources.file.visitor.ResourceFileVisitor;
import proguard.resources.kotlinmodule.KotlinModule;
import proguard.resources.kotlinmodule.visitor.KotlinModuleVisitor;
import proguard.util.ProcessingFlagSetter;
import proguard.util.kotlin.asserter.DefaultReporter;
import proguard.util.kotlin.asserter.Reporter;
import proguard.util.kotlin.asserter.constraint.ClassIntegrity;
import proguard.util.kotlin.asserter.constraint.ConstructorIntegrity;
import proguard.util.kotlin.asserter.constraint.DeclarationContainerIntegrity;
import proguard.util.kotlin.asserter.constraint.FileFacadeIntegrity;
import proguard.util.kotlin.asserter.constraint.FunctionIntegrity;
import proguard.util.kotlin.asserter.constraint.KmAnnotationIntegrity;
import proguard.util.kotlin.asserter.constraint.KotlinAsserterConstraint;
import proguard.util.kotlin.asserter.constraint.KotlinModuleIntegrity;
import proguard.util.kotlin.asserter.constraint.MultiFilePartIntegrity;
import proguard.util.kotlin.asserter.constraint.PropertyIntegrity;
import proguard.util.kotlin.asserter.constraint.SyntheticClassIntegrity;
import proguard.util.kotlin.asserter.constraint.TypeIntegrity;
import proguard.util.kotlin.asserter.constraint.ValueParameterIntegrity;

public class KotlinMetadataAsserter
implements Pass {
    private static final List<KotlinAsserterConstraint> DEFAULT_CONSTRAINTS = Arrays.asList(new FunctionIntegrity(), new ConstructorIntegrity(), new PropertyIntegrity(), new ClassIntegrity(), new TypeIntegrity(), new KmAnnotationIntegrity(), new ValueParameterIntegrity(), new SyntheticClassIntegrity(), new FileFacadeIntegrity(), new MultiFilePartIntegrity(), new DeclarationContainerIntegrity(), new KotlinModuleIntegrity());
    private final Configuration configuration;

    public KotlinMetadataAsserter(Configuration configuration) {
        this.configuration = configuration;
    }

    @Override
    public void execute(AppView appView) {
        PrintWriter err = new PrintWriter(System.err, true);
        WarningPrinter warningPrinter = new WarningPrinter(err, this.configuration.warn);
        DefaultReporter reporter = new DefaultReporter(warningPrinter);
        MyKotlinMetadataAsserter kotlinMetadataAsserter = new MyKotlinMetadataAsserter(reporter, DEFAULT_CONSTRAINTS, appView.programClassPool, appView.libraryClassPool);
        reporter.setErrorMessage("Warning: Kotlin metadata errors encountered in %s. Not processing the metadata for this class.");
        appView.programClassPool.classesAccept((ClassVisitor)new ReferencedKotlinMetadataVisitor((KotlinMetadataVisitor)kotlinMetadataAsserter));
        appView.libraryClassPool.classesAccept((ClassVisitor)new ReferencedKotlinMetadataVisitor((KotlinMetadataVisitor)kotlinMetadataAsserter));
        reporter.setErrorMessage("Warning: Kotlin module errors encountered in module %s. Not processing the metadata for this module.");
        appView.resourceFilePool.resourceFilesAccept((ResourceFileVisitor)new ResourceFileProcessingFlagFilter(0, 8192, (ResourceFileVisitor)kotlinMetadataAsserter));
    }

    public static class MyKotlinMetadataAsserter
    implements KotlinMetadataVisitor,
    ResourceFileVisitor,
    KotlinModuleVisitor {
        private final List<? extends KotlinAsserterConstraint> constraints;
        private final Reporter reporter;
        private final ClassPool programClassPool;
        private final ClassPool libraryClassPool;

        MyKotlinMetadataAsserter(Reporter reporter, List<KotlinAsserterConstraint> constraints, ClassPool programClassPool, ClassPool libraryClassPool) {
            this.constraints = constraints;
            this.reporter = reporter;
            this.programClassPool = programClassPool;
            this.libraryClassPool = libraryClassPool;
        }

        public void visitAnyKotlinMetadata(Clazz clazz, KotlinMetadata kotlinMetadata) {
            this.reporter.resetCounter(clazz.getName());
            this.constraints.forEach(constraint -> constraint.check(this.reporter, this.programClassPool, this.libraryClassPool, clazz, kotlinMetadata));
            if (this.reporter.getCount() > 0) {
                clazz.accept((ClassVisitor)new KotlinMetadataRemover());
            }
        }

        public void visitKotlinModule(KotlinModule kotlinModule) {
            this.reporter.resetCounter(kotlinModule.name);
            this.constraints.forEach(constraint -> constraint.check(this.reporter, kotlinModule));
            if (this.reporter.getCount() > 0) {
                kotlinModule.accept((ResourceFileVisitor)new ProcessingFlagSetter(8192));
            }
        }

        public void visitResourceFile(ResourceFile resourceFile) {
        }
    }
}

