/*
 * Decompiled with CFR 0.152.
 */
package proguard.shrink;

import proguard.classfile.Clazz;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramField;
import proguard.classfile.attribute.RecordComponentInfo;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.attribute.visitor.RecordComponentInfoVisitor;
import proguard.classfile.constant.Utf8Constant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.visitor.MemberVisitor;
import proguard.shrink.ClassUsageMarker;
import proguard.util.Processable;

public class RecordComponentUsageMarker
implements RecordComponentInfoVisitor,
MemberVisitor,
ConstantVisitor {
    private final ClassUsageMarker classUsageMarker;
    private boolean fieldUsed;

    public RecordComponentUsageMarker(ClassUsageMarker classUsageMarker) {
        this.classUsageMarker = classUsageMarker;
    }

    public void visitRecordComponentInfo(Clazz clazz, RecordComponentInfo recordComponentInfo) {
        this.fieldUsed = false;
        recordComponentInfo.referencedFieldAccept(clazz, (MemberVisitor)this);
        if (this.fieldUsed) {
            this.classUsageMarker.markAsUsed((Processable)recordComponentInfo);
            this.markConstant(clazz, recordComponentInfo.u2nameIndex);
            this.markConstant(clazz, recordComponentInfo.u2descriptorIndex);
            recordComponentInfo.attributesAccept(clazz, (AttributeVisitor)this.classUsageMarker);
        }
    }

    public void visitProgramField(ProgramClass programClass, ProgramField programField) {
        this.fieldUsed = this.classUsageMarker.isUsed((Processable)programField);
    }

    public void visitUtf8Constant(Clazz clazz, Utf8Constant utf8Constant) {
        this.classUsageMarker.markAsUsed((Processable)utf8Constant);
    }

    private void markConstant(Clazz clazz, int index) {
        clazz.constantPoolEntryAccept(index, (ConstantVisitor)this);
    }
}

