/*
 * Decompiled with CFR 0.152.
 */
package proguard.backport;

import proguard.classfile.ClassPool;
import proguard.classfile.Clazz;
import proguard.classfile.Member;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramField;
import proguard.classfile.ProgramMethod;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.LocalVariableInfo;
import proguard.classfile.attribute.LocalVariableTableAttribute;
import proguard.classfile.attribute.LocalVariableTypeInfo;
import proguard.classfile.attribute.LocalVariableTypeTableAttribute;
import proguard.classfile.attribute.SignatureAttribute;
import proguard.classfile.attribute.annotation.Annotation;
import proguard.classfile.attribute.annotation.AnnotationDefaultAttribute;
import proguard.classfile.attribute.annotation.AnnotationElementValue;
import proguard.classfile.attribute.annotation.AnnotationsAttribute;
import proguard.classfile.attribute.annotation.ArrayElementValue;
import proguard.classfile.attribute.annotation.ClassElementValue;
import proguard.classfile.attribute.annotation.ElementValue;
import proguard.classfile.attribute.annotation.EnumConstantElementValue;
import proguard.classfile.attribute.annotation.ParameterAnnotationsAttribute;
import proguard.classfile.attribute.annotation.visitor.AnnotationVisitor;
import proguard.classfile.attribute.annotation.visitor.ElementValueVisitor;
import proguard.classfile.attribute.visitor.AllAttributeVisitor;
import proguard.classfile.attribute.visitor.AttributeNameFilter;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.attribute.visitor.LocalVariableInfoVisitor;
import proguard.classfile.attribute.visitor.LocalVariableTypeInfoVisitor;
import proguard.classfile.constant.AnyMethodrefConstant;
import proguard.classfile.constant.ClassConstant;
import proguard.classfile.constant.Constant;
import proguard.classfile.constant.FieldrefConstant;
import proguard.classfile.constant.RefConstant;
import proguard.classfile.constant.visitor.ConstantTagFilter;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.editor.CodeAttributeEditor;
import proguard.classfile.editor.ConstantPoolEditor;
import proguard.classfile.editor.ConstantPoolShrinker;
import proguard.classfile.instruction.ConstantInstruction;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.visitor.InstructionVisitor;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.util.DescriptorClassEnumeration;
import proguard.classfile.util.WarningPrinter;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.MemberVisitor;
import proguard.util.ClassNameParser;
import proguard.util.ConstantMatcher;
import proguard.util.NameParser;
import proguard.util.StringMatcher;

class AbstractAPIConverter
implements ClassVisitor,
MemberVisitor,
AttributeVisitor,
InstructionVisitor,
ConstantVisitor,
LocalVariableInfoVisitor,
LocalVariableTypeInfoVisitor,
AnnotationVisitor,
ElementValueVisitor {
    private static final boolean DEBUG = false;
    private final ClassPool programClassPool;
    private final ClassPool libraryClassPool;
    private final WarningPrinter warningPrinter;
    private final ClassVisitor modifiedClassVisitor;
    private final InstructionVisitor extraInstructionVisitor;
    private TypeReplacement[] typeReplacements;
    private MethodReplacement[] methodReplacements;
    private final CodeAttributeEditor codeAttributeEditor = new CodeAttributeEditor(true, true);
    private ConstantPoolEditor constantPoolEditor;
    private int referencingOffset;
    private Method referencingMethod;
    private boolean classModified;
    private boolean instructionReplaced;

    AbstractAPIConverter(ClassPool programClassPool, ClassPool libraryClassPool, WarningPrinter warningPrinter, ClassVisitor modifiedClassVisitor, InstructionVisitor extraInstructionVisitor) {
        this.programClassPool = programClassPool;
        this.libraryClassPool = libraryClassPool;
        this.warningPrinter = warningPrinter;
        this.modifiedClassVisitor = modifiedClassVisitor;
        this.extraInstructionVisitor = extraInstructionVisitor;
    }

    protected MethodReplacement replace(String className, String methodName, String methodDesc, String replacementClassName, String replacementMethodName, String replacementMethodDesc) {
        MethodReplacement methodReplacement = new MethodReplacement(className, methodName, methodDesc, replacementClassName, replacementMethodName, replacementMethodDesc);
        return methodReplacement.isValid() ? methodReplacement : this.missing(className, methodName, methodDesc);
    }

    protected TypeReplacement replace(String className, String replacementClassName) {
        TypeReplacement typeReplacement = new TypeReplacement(className, replacementClassName);
        return typeReplacement.isValid() ? typeReplacement : this.missing(className);
    }

    protected MethodReplacement missing(String className, String methodName, String methodDesc) {
        return new MissingMethodReplacement(className, methodName, methodDesc);
    }

    protected TypeReplacement missing(String className) {
        return new MissingTypeReplacement(className);
    }

    protected void setTypeReplacements(TypeReplacement[] replacements) {
        this.typeReplacements = replacements;
    }

    protected void setMethodReplacements(MethodReplacement[] replacements) {
        this.methodReplacements = replacements;
    }

    public void visitAnyClass(Clazz clazz) {
    }

    public void visitProgramClass(ProgramClass programClass) {
        this.constantPoolEditor = new ConstantPoolEditor(programClass);
        this.classModified = false;
        programClass.methodsAccept((MemberVisitor)new AllAttributeVisitor((AttributeVisitor)new AttributeNameFilter("Code", (AttributeVisitor)this)));
        programClass.constantPoolEntriesAccept((ConstantVisitor)new ConstantTagFilter(7, (ConstantVisitor)this));
        programClass.fieldsAccept((MemberVisitor)this);
        programClass.methodsAccept((MemberVisitor)this);
        programClass.attributesAccept((AttributeVisitor)this);
        if (this.classModified) {
            programClass.accept((ClassVisitor)new ConstantPoolShrinker());
            if (this.modifiedClassVisitor != null) {
                this.modifiedClassVisitor.visitProgramClass(programClass);
            }
        }
    }

    public void visitAnyMember(Clazz clazz, Member member) {
    }

    public void visitProgramField(ProgramClass programClass, ProgramField programField) {
        programField.u2descriptorIndex = this.updateDescriptor((Clazz)programClass, programField.u2descriptorIndex);
        programField.attributesAccept(programClass, (AttributeVisitor)this);
    }

    public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
        programMethod.u2descriptorIndex = this.updateDescriptor((Clazz)programClass, programMethod.u2descriptorIndex);
        programMethod.attributesAccept(programClass, (AttributeVisitor)new AttributeNameFilter("!Code", (AttributeVisitor)this));
    }

    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        this.codeAttributeEditor.reset(codeAttribute.u4codeLength);
        codeAttribute.instructionsAccept(clazz, method, (InstructionVisitor)this);
        if (this.codeAttributeEditor.isModified()) {
            this.codeAttributeEditor.visitCodeAttribute(clazz, method, codeAttribute);
        }
        codeAttribute.attributesAccept(clazz, method, (AttributeVisitor)this);
    }

    public void visitLocalVariableTableAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, LocalVariableTableAttribute localVariableTableAttribute) {
        localVariableTableAttribute.localVariablesAccept(clazz, method, codeAttribute, (LocalVariableInfoVisitor)this);
    }

    public void visitLocalVariableTypeTableAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, LocalVariableTypeTableAttribute localVariableTypeTableAttribute) {
        localVariableTypeTableAttribute.localVariablesAccept(clazz, method, codeAttribute, (LocalVariableTypeInfoVisitor)this);
    }

    public void visitSignatureAttribute(Clazz clazz, SignatureAttribute signatureAttribute) {
        signatureAttribute.u2signatureIndex = this.updateDescriptor(clazz, signatureAttribute.u2signatureIndex);
    }

    public void visitAnyAnnotationsAttribute(Clazz clazz, AnnotationsAttribute annotationsAttribute) {
        annotationsAttribute.annotationsAccept(clazz, (AnnotationVisitor)this);
    }

    public void visitAnyParameterAnnotationsAttribute(Clazz clazz, Method method, ParameterAnnotationsAttribute parameterAnnotationsAttribute) {
        parameterAnnotationsAttribute.annotationsAccept(clazz, method, (AnnotationVisitor)this);
    }

    public void visitAnnotationDefaultAttribute(Clazz clazz, Method method, AnnotationDefaultAttribute annotationDefaultAttribute) {
        annotationDefaultAttribute.defaultValueAccept(clazz, (ElementValueVisitor)this);
    }

    public void visitLocalVariableInfo(Clazz clazz, Method method, CodeAttribute codeAttribute, LocalVariableInfo localVariableInfo) {
        localVariableInfo.u2descriptorIndex = this.updateDescriptor(clazz, localVariableInfo.u2descriptorIndex);
    }

    public void visitLocalVariableTypeInfo(Clazz clazz, Method method, CodeAttribute codeAttribute, LocalVariableTypeInfo localVariableTypeInfo) {
        localVariableTypeInfo.u2signatureIndex = this.updateDescriptor(clazz, localVariableTypeInfo.u2signatureIndex);
    }

    public void visitAnnotation(Clazz clazz, Annotation annotation) {
        annotation.u2typeIndex = this.updateDescriptor(clazz, annotation.u2typeIndex);
        annotation.elementValuesAccept(clazz, (ElementValueVisitor)this);
    }

    public void visitAnyElementValue(Clazz clazz, Annotation annotation, ElementValue elementValue) {
    }

    public void visitEnumConstantElementValue(Clazz clazz, Annotation annotation, EnumConstantElementValue enumConstantElementValue) {
        enumConstantElementValue.u2typeNameIndex = this.updateDescriptor(clazz, enumConstantElementValue.u2typeNameIndex);
    }

    public void visitClassElementValue(Clazz clazz, Annotation annotation, ClassElementValue classElementValue) {
        String className = classElementValue.getClassName(clazz);
        String newClassName = this.replaceClassName(clazz, className);
        if (!newClassName.equals(className)) {
            this.classModified = true;
            classElementValue.u2classInfoIndex = this.constantPoolEditor.addUtf8Constant(newClassName);
        }
    }

    public void visitAnnotationElementValue(Clazz clazz, Annotation annotation, AnnotationElementValue annotationElementValue) {
        annotationElementValue.annotationAccept(clazz, (AnnotationVisitor)this);
    }

    public void visitArrayElementValue(Clazz clazz, Annotation annotation, ArrayElementValue arrayElementValue) {
        arrayElementValue.elementValuesAccept(clazz, annotation, (ElementValueVisitor)this);
    }

    public void visitAnyInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, Instruction instruction) {
    }

    public void visitConstantInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, ConstantInstruction constantInstruction) {
        switch (constantInstruction.opcode) {
            case -74: 
            case -73: 
            case -72: 
            case -71: {
                this.referencingOffset = offset;
                this.referencingMethod = method;
                this.instructionReplaced = false;
                clazz.constantPoolEntryAccept(constantInstruction.constantIndex, (ConstantVisitor)this);
                if (!this.instructionReplaced || this.extraInstructionVisitor == null) break;
                this.extraInstructionVisitor.visitConstantInstruction(clazz, method, codeAttribute, offset, constantInstruction);
                break;
            }
            case -78: 
            case -77: 
            case -76: 
            case -75: {
                this.referencingOffset = offset;
                this.referencingMethod = method;
                this.instructionReplaced = false;
                clazz.constantPoolEntryAccept(constantInstruction.constantIndex, (ConstantVisitor)this);
                if (!this.instructionReplaced || this.extraInstructionVisitor == null) break;
                this.extraInstructionVisitor.visitConstantInstruction(clazz, method, codeAttribute, offset, constantInstruction);
            }
        }
    }

    public void visitAnyConstant(Clazz clazz, Constant constant) {
    }

    public void visitClassConstant(Clazz clazz, ClassConstant classConstant) {
        String className = classConstant.getName(clazz);
        String newClassName = this.replaceClassName(clazz, className);
        if (!newClassName.equals(className)) {
            classConstant.u2nameIndex = this.constantPoolEditor.addUtf8Constant(newClassName);
            this.classModified = true;
        }
    }

    public void visitFieldrefConstant(Clazz clazz, FieldrefConstant fieldrefConstant) {
        String name = fieldrefConstant.getName(clazz);
        String desc = fieldrefConstant.getType(clazz);
        String newDesc = this.replaceDescriptor(clazz, desc);
        if (!newDesc.equals(desc)) {
            fieldrefConstant.u2nameAndTypeIndex = this.constantPoolEditor.addNameAndTypeConstant(name, newDesc);
            this.classModified = true;
        }
    }

    public void visitAnyMethodrefConstant(Clazz clazz, AnyMethodrefConstant anyMethodrefConstant) {
        if (!this.replaceMethodInvocation(this.referencingOffset, clazz, this.referencingMethod, anyMethodrefConstant)) {
            String name = anyMethodrefConstant.getName(clazz);
            String desc = anyMethodrefConstant.getType(clazz);
            String newDesc = this.replaceDescriptor(clazz, desc);
            if (!newDesc.equals(desc)) {
                anyMethodrefConstant.u2nameAndTypeIndex = this.constantPoolEditor.addNameAndTypeConstant(name, newDesc);
                this.classModified = true;
            }
        }
    }

    private String replaceClassName(Clazz clazz, String className) {
        for (TypeReplacement typeReplacement : this.typeReplacements) {
            String newClassName;
            String string = newClassName = typeReplacement.matchesClassName(className) ? typeReplacement.replaceClassName(clazz, className) : null;
            if (newClassName == null) continue;
            return newClassName;
        }
        return className;
    }

    private String replaceDescriptor(Clazz clazz, String descriptor) {
        DescriptorClassEnumeration descriptorClassEnumeration = new DescriptorClassEnumeration(descriptor);
        StringBuilder newDescriptorBuilder = new StringBuilder(descriptor.length());
        newDescriptorBuilder.append(descriptorClassEnumeration.nextFluff());
        while (descriptorClassEnumeration.hasMoreClassNames()) {
            String className = descriptorClassEnumeration.nextClassName();
            boolean isInnerClassName = descriptorClassEnumeration.isInnerClassName();
            String fluff = descriptorClassEnumeration.nextFluff();
            if (isInnerClassName) {
                className = className.substring(className.lastIndexOf(36) + 1);
            }
            newDescriptorBuilder.append(this.replaceClassName(clazz, className));
            newDescriptorBuilder.append(fluff);
        }
        return newDescriptorBuilder.toString();
    }

    private int updateDescriptor(Clazz clazz, int descriptorIndex) {
        String descriptor = clazz.getString(descriptorIndex);
        String newDescriptor = this.replaceDescriptor(clazz, descriptor);
        if (!newDescriptor.equals(descriptor)) {
            this.classModified = true;
            return this.constantPoolEditor.addUtf8Constant(newDescriptor);
        }
        return descriptorIndex;
    }

    private boolean replaceMethodInvocation(int offset, Clazz clazz, Method method, AnyMethodrefConstant anyMethodrefConstant) {
        for (MethodReplacement methodReplacement : this.methodReplacements) {
            if (!methodReplacement.matches(clazz, anyMethodrefConstant)) continue;
            methodReplacement.replaceInstruction(offset, clazz, method, anyMethodrefConstant);
            this.classModified = true;
            this.instructionReplaced = true;
            return true;
        }
        return false;
    }

    private class MissingTypeReplacement
    extends TypeReplacement {
        MissingTypeReplacement(String className) {
            super(className, null);
        }

        @Override
        boolean isValid() {
            return false;
        }

        @Override
        String replaceClassName(Clazz clazz, String className) {
            AbstractAPIConverter.this.warningPrinter.print(clazz.getName(), String.format("Warning: no replacement available for class '%s'\n         found in class '%s'.", ClassUtil.externalClassName((String)className), ClassUtil.externalClassName((String)clazz.getName())));
            return className;
        }
    }

    protected class TypeReplacement
    extends AbstractReplacement {
        final String matchingClassName;
        final String replacementClassName;
        final StringMatcher classNameMatcher;

        TypeReplacement(String matchingClassName, String replacementClassName) {
            this.matchingClassName = matchingClassName;
            this.replacementClassName = replacementClassName;
            this.classNameMatcher = new ClassNameParser(null).parse(matchingClassName);
        }

        boolean isValid() {
            return this.replacementClassName.contains("*") || this.replacementClassName.contains("<1>") || this.findReferencedClass(this.replacementClassName) != null;
        }

        boolean matchesClassName(String className) {
            return this.classNameMatcher.matches(className);
        }

        String replaceClassName(Clazz clazz, String className) {
            return this.getReplacement(this.matchingClassName, className, this.replacementClassName);
        }
    }

    private class MissingMethodReplacement
    extends MethodReplacement {
        MissingMethodReplacement(String className, String methodName, String methodDesc) {
            super(className, methodName, methodDesc, null, null, null);
        }

        boolean isValid() {
            return false;
        }

        void replaceInstruction(int offset, Clazz clazz, Method method, RefConstant refConstant) {
            String className = refConstant.getClassName(clazz);
            String methodName = refConstant.getName(clazz);
            String methodDesc = refConstant.getType(clazz);
            AbstractAPIConverter.this.warningPrinter.print(clazz.getName(), String.format("Warning: no replacement available for '%s.%s(%s)'\n         found at offset %d in method '%s.%s(%s)'.", ClassUtil.externalClassName((String)className), methodName, ClassUtil.externalMethodArguments((String)methodDesc), offset, ClassUtil.externalClassName((String)clazz.getName()), method.getName(clazz), ClassUtil.externalMethodArguments((String)method.getDescriptor(clazz))));
        }
    }

    protected class MethodReplacement
    extends AbstractReplacement {
        final String matchingClassName;
        final String matchingMethodName;
        final String matchingMethodDesc;
        final String replacementClassName;
        final String replacementMethodName;
        final String replacementMethodDesc;
        final StringMatcher classNameMatcher;
        final StringMatcher methodNameMatcher;
        final StringMatcher descMatcher;

        MethodReplacement(String className, String methodName, String methodDesc, String replacementClassName, String replacementMethodName, String replacementMethodDesc) {
            this.matchingClassName = className;
            this.matchingMethodName = methodName;
            this.matchingMethodDesc = methodDesc;
            this.replacementClassName = replacementClassName;
            this.replacementMethodName = replacementMethodName;
            this.replacementMethodDesc = replacementMethodDesc;
            this.classNameMatcher = new ClassNameParser(null).parse(this.matchingClassName);
            this.methodNameMatcher = new NameParser().parse(this.matchingMethodName);
            this.descMatcher = this.matchingMethodDesc.equals("**") ? new ConstantMatcher(true) : new ClassNameParser(null).parse(this.matchingMethodDesc);
        }

        private boolean isValid() {
            return this.replacementClassName.contains("*") || this.replacementClassName.contains("<1>") || this.findReferencedClass(this.replacementClassName) != null;
        }

        private String getDescReplacement(String original, String actual, String replacement) {
            if (this.matchingMethodName.equals("<default>")) {
                String replacedDesc = this.getReplacement(original, actual, replacement);
                return "(" + ClassUtil.internalTypeFromClassName((String)this.matchingClassName) + replacedDesc.substring(1);
            }
            return this.getReplacement(original, actual, replacement);
        }

        boolean matches(Clazz clazz, AnyMethodrefConstant anyMethodrefConstant) {
            String className = anyMethodrefConstant.getClassName(clazz);
            String methodName = anyMethodrefConstant.getName(clazz);
            String methodDesc = anyMethodrefConstant.getType(clazz);
            Clazz referencedMatchingClass = this.findReferencedClass(this.matchingClassName);
            Clazz referencedClass = anyMethodrefConstant.referencedClass;
            if (referencedClass == null) {
                return false;
            }
            Method referencedMethod = anyMethodrefConstant.referencedMethod;
            if (referencedMethod == null) {
                return false;
            }
            return this.classPatternMatches(className, referencedClass, referencedMatchingClass) && this.methodPatternMatches(methodName, referencedClass, referencedMethod) && this.descPatternMatches(methodDesc);
        }

        private boolean classPatternMatches(String className, Clazz referencedClazz, Clazz referencedMatchingClass) {
            return this.classNameMatcher.matches(className) || referencedClazz != null && referencedClazz.extendsOrImplements(referencedMatchingClass);
        }

        private boolean methodPatternMatches(String methodName, Clazz referencedClass, Method referencedMethod) {
            return this.methodNameMatcher.matches(methodName) || this.matchingMethodName.equals("<default>") && this.isDefaultMethod(referencedClass, referencedMethod) || this.matchingMethodName.equals("<static>") && this.isStatic(referencedMethod);
        }

        private boolean descPatternMatches(String methodDesc) {
            return this.descMatcher.matches(methodDesc);
        }

        void replaceInstruction(int offset, Clazz clazz, Method method, AnyMethodrefConstant anyMethodrefConstant) {
            String className = this.getReplacement(this.matchingClassName, anyMethodrefConstant.getClassName(clazz), this.replacementClassName);
            String methodName = this.getReplacement(this.matchingMethodName, anyMethodrefConstant.getName(clazz), this.replacementMethodName);
            String methodDesc = this.getDescReplacement(this.matchingMethodDesc, anyMethodrefConstant.getType(clazz), this.replacementMethodDesc);
            methodDesc = AbstractAPIConverter.this.replaceDescriptor(clazz, methodDesc);
            Clazz referencedClass = this.findReferencedClass(className);
            if (referencedClass == null) {
                return;
            }
            Method referencedMethod = this.findReferencedMethod(referencedClass, methodName, methodDesc);
            if (referencedMethod == null) {
                AbstractAPIConverter.this.warningPrinter.print(clazz.getName(), className, String.format("Warning: could not find replacement method '%s.%s(%s)',\n         not converting method instruction at offset %d in method '%s.%s(%s)'.", ClassUtil.externalClassName((String)className), methodName, ClassUtil.externalMethodArguments((String)methodDesc), offset, ClassUtil.externalClassName((String)clazz.getName()), method.getName(clazz), ClassUtil.externalMethodArguments((String)method.getDescriptor(clazz))));
                return;
            }
            boolean isInterfaceMethod = this.isInterface(referencedClass);
            byte replacementInstructionOpcode = this.isStatic(referencedMethod) ? (byte)-72 : (isInterfaceMethod ? (byte)-71 : -74);
            int methodConstant = isInterfaceMethod ? AbstractAPIConverter.this.constantPoolEditor.addInterfaceMethodrefConstant(className, methodName, methodDesc, referencedClass, referencedMethod) : AbstractAPIConverter.this.constantPoolEditor.addMethodrefConstant(className, methodName, methodDesc, referencedClass, referencedMethod);
            AbstractAPIConverter.this.codeAttributeEditor.replaceInstruction(offset, (Instruction)new ConstantInstruction(replacementInstructionOpcode, methodConstant));
        }
    }

    private abstract class AbstractReplacement {
        private AbstractReplacement() {
        }

        boolean isStatic(Method method) {
            return (method.getAccessFlags() & 8) != 0;
        }

        boolean isDefaultMethod(Clazz clazz, Method method) {
            return this.isInterface(clazz) && (method.getAccessFlags() & 0x400) == 0;
        }

        boolean isInterface(Clazz clazz) {
            return (clazz.getAccessFlags() & 0x200) != 0;
        }

        Clazz findReferencedClass(String className) {
            Clazz clazz = AbstractAPIConverter.this.programClassPool.getClass(className);
            return clazz != null ? clazz : AbstractAPIConverter.this.libraryClassPool.getClass(className);
        }

        Method findReferencedMethod(Clazz clazz, String methodName, String methodDescriptor) {
            return clazz.findMethod(methodName, methodDescriptor);
        }

        String getReplacement(String original, String actual, String replacement) {
            if (replacement.contains("<1>")) {
                if (original.equals("<static>") || original.equals("<default>")) {
                    return actual;
                }
                int wildcardIndex = original.indexOf("*");
                if (wildcardIndex != -1) {
                    String match = actual.substring(wildcardIndex);
                    int replacementIndex = replacement.indexOf("<1>");
                    return replacement.substring(0, replacementIndex) + match;
                }
                return original;
            }
            return replacement;
        }
    }
}

