/*
 * Decompiled with CFR 0.152.
 */
package com.guardanis.netclient;

import java.util.HashMap;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class WebResult {
    private int responseCode;
    private String unparsedResponse;
    private long createdAtMs = 0L;
    private Map<String, Object> extras = new HashMap<String, Object>();

    public WebResult(int responseCode, String unparsedResponse) {
        this(responseCode, unparsedResponse, System.currentTimeMillis());
    }

    public WebResult(int responseCode, String unparsedResponse, long createdAtMs) {
        this.responseCode = responseCode;
        this.unparsedResponse = unparsedResponse;
        this.createdAtMs = createdAtMs;
    }

    public Map<String, Object> getExtras() {
        return this.extras;
    }

    public WebResult setExtras(Map<String, Object> extras) {
        this.extras = extras;
        return this;
    }

    public WebResult putExtra(String key, Object data) {
        this.extras.put(key, data);
        return this;
    }

    public int getResponseCode() {
        return this.responseCode;
    }

    public String getUnparsedResponse() {
        return this.unparsedResponse;
    }

    public boolean isSuccessful() {
        return this.responseCode >= 200 && this.responseCode < 400;
    }

    public boolean isResponseCodeKnown() {
        return this.responseCode > 0;
    }

    public boolean isResponseJson() {
        try {
            new JSONObject(this.unparsedResponse);
            return true;
        }
        catch (JSONException jSONException) {
            return false;
        }
    }

    public JSONObject getResponseJson() {
        try {
            return new JSONObject(this.unparsedResponse);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public long getCreatedAtMs() {
        return this.createdAtMs;
    }
}

