/*
 * Decompiled with CFR 0.152.
 */
package com.guardanis.netclient;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import com.guardanis.netclient.CustomSSLSocketFactory;
import com.guardanis.netclient.NetInterface;
import com.guardanis.netclient.R;
import com.guardanis.netclient.WebResult;
import com.guardanis.netclient.errors.ApiError;
import com.guardanis.netclient.errors.ErrorParser;
import com.guardanis.netclient.errors.GeneralError;
import com.guardanis.netclient.errors.RequestCanceledError;
import com.guardanis.netclient.errors.RequestError;
import com.guardanis.netclient.tools.InputStreamHelper;
import com.guardanis.netclient.tools.NetUtils;
import com.guardanis.netclient.tools.OutputStreamHelper;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.HttpsURLConnection;
import org.json.JSONObject;

public class WebRequest<T>
implements Runnable {
    private static final int CORE_POOL_SIZE = 15;
    private static final int MAXIMUM_POOL_SIZE = 64;
    private static final int KEEP_ALIVE = 1;
    private static final ThreadFactory sThreadFactory = new ThreadFactory(){
        private final AtomicInteger mCount = new AtomicInteger(1);

        @Override
        public Thread newThread(Runnable r) {
            return new Thread(r, "NetTask #" + this.mCount.getAndIncrement());
        }
    };
    private static final BlockingQueue<Runnable> THREAD_POOL_QUEUE = new LinkedBlockingQueue<Runnable>(30);
    protected static final Executor EXECUTOR = new ThreadPoolExecutor(15, 64, 1L, TimeUnit.SECONDS, THREAD_POOL_QUEUE, sThreadFactory);
    protected Context context;
    protected ConnectionType connectionType;
    protected String targetUrl = "";
    protected Map<String, String> requestProperties = new HashMap<String, String>();
    protected String data;
    protected NetInterface.ResponseParser<T> responseParser;
    protected NetInterface.SuccessListener<T> successListener;
    protected NetInterface.FailListener failListener;
    protected Looper originatingLooper;
    protected boolean canceled = false;
    protected boolean failOnCancel = false;
    protected ErrorParser errorParser;
    protected int sslCertResource = R.raw.nc__cert;
    protected String sslCertPassword;
    protected boolean unsafeSslModeEnabled = false;

    public WebRequest(Context context, ConnectionType connectionType) {
        this(context, connectionType, "");
    }

    public WebRequest(Context context, ConnectionType connectionType, String targetUrl) {
        this.context = context;
        this.connectionType = connectionType;
        this.sslCertPassword = context.getString(R.string.nc__ssl_cert_keystore_password);
        this.setTargetUrl(targetUrl);
    }

    public WebRequest<T> setTargetUrl(String targetUrl) {
        this.targetUrl = targetUrl.trim();
        return this;
    }

    public WebRequest<T> setData(NetInterface.Jsonable data) {
        return this.setData(data.toJson());
    }

    public WebRequest<T> setData(JSONObject data) {
        return this.setData(data.toString());
    }

    public WebRequest<T> setData(String data) {
        this.data = data;
        return this;
    }

    public WebRequest<T> addRequestProperty(String key, String value) {
        this.requestProperties.put(key, value);
        return this;
    }

    public WebRequest<T> setResponseParser(NetInterface.ResponseParser<T> responseParser) {
        this.responseParser = responseParser;
        return this;
    }

    public WebRequest<T> onSuccess(NetInterface.SuccessListener<T> successListener) {
        this.successListener = successListener;
        return this;
    }

    public WebRequest<T> onFail(NetInterface.FailListener failListener) {
        this.failListener = failListener;
        return this;
    }

    public WebRequest<T> setFailOnCancel(boolean failOnCancel) {
        this.failOnCancel = failOnCancel;
        return this;
    }

    public WebRequest<T> setErrorParser(ErrorParser errorParser) {
        this.errorParser = errorParser;
        return this;
    }

    public WebRequest<T> setSslCertificateInfo(int sslCertResource, String sslCertPassword) {
        this.sslCertResource = sslCertResource;
        this.sslCertPassword = sslCertPassword;
        return this;
    }

    public WebRequest<T> setSslUnsafeModeEnabled(boolean unsafeSslModeEnabled) {
        this.unsafeSslModeEnabled = unsafeSslModeEnabled;
        return this;
    }

    public WebRequest<T> execute() {
        this.originatingLooper = Looper.myLooper();
        EXECUTOR.execute(new Thread(this));
        return this;
    }

    @Override
    public void run() {
        try {
            HttpURLConnection connection = this.openConnection();
            if (this.connectionType == ConnectionType.POST) {
                connection.setDoOutput(true);
            }
            connection.setRequestMethod(this.connectionType.name());
            this.setRequestProperties(connection);
            WebResult result = this.makeRequest(connection, this.data);
            this.onResponseReceived(result);
        }
        catch (Throwable e) {
            this.postToOriginalThread(new Runnable(){

                @Override
                public void run() {
                    if (WebRequest.this.failListener != null) {
                        WebRequest.this.failListener.onFail(new GeneralError(WebRequest.this.context, e));
                    }
                }
            });
            e.printStackTrace();
        }
    }

    protected HttpURLConnection openConnection() throws Exception {
        URL url = this.buildUrl();
        if (this.targetUrl.startsWith("https://")) {
            HttpsURLConnection conn = (HttpsURLConnection)url.openConnection();
            CustomSSLSocketFactory factory = this.unsafeSslModeEnabled ? CustomSSLSocketFactory.getUnsafeInstance() : CustomSSLSocketFactory.getInstance(this.context, this.sslCertResource, this.sslCertPassword);
            conn.setSSLSocketFactory(factory.currentContext.getSocketFactory());
            return conn;
        }
        return (HttpURLConnection)url.openConnection();
    }

    protected void setRequestProperties(HttpURLConnection conn) {
        conn.setRequestProperty("Accept", NetUtils.getInstance(this.context).getAcceptProperty());
        conn.setRequestProperty("Content-type", NetUtils.getInstance(this.context).getContentTypeProperty());
        for (String key : this.requestProperties.keySet()) {
            conn.setRequestProperty(key, this.requestProperties.get(key));
        }
    }

    protected URL buildUrl() throws MalformedURLException, UnsupportedEncodingException {
        return new URL(this.targetUrl);
    }

    protected WebResult makeRequest(HttpURLConnection conn, String params) throws Exception {
        OutputStreamHelper streamHelper = new OutputStreamHelper(conn);
        streamHelper.write(params);
        WebResult response = this.readResponse(conn);
        streamHelper.closeConnection();
        NetUtils.getInstance(this.context).log("Server response: " + response.getUnparsedResponse());
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected WebResult readResponse(HttpURLConnection conn) throws Exception {
        InputStreamHelper streamHelper = null;
        String response = "";
        try {
            streamHelper = new InputStreamHelper(conn);
            response = streamHelper.read();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (streamHelper != null) {
                streamHelper.closeConnection();
            }
        }
        return new WebResult(conn.getResponseCode(), response);
    }

    protected void onResponseReceived(WebResult result) throws Exception {
        RequestError errors = this.getErrorsFromResult(result);
        if (errors != null && errors.hasErrors()) {
            this.failWith(errors);
        } else {
            this.finishWith(this.responseParser.parse(result));
        }
    }

    protected RequestError getErrorsFromResult(WebResult result) {
        return this.errorParser == null ? null : new ApiError(result, this.errorParser);
    }

    protected void failWith(final RequestError errors) {
        this.postToOriginalThread(new Runnable(){

            @Override
            public void run() {
                if (WebRequest.this.failListener != null) {
                    WebRequest.this.failListener.onFail(errors);
                }
            }
        });
    }

    protected void finishWith(final T parsedResult) {
        this.postToOriginalThread(new Runnable(){

            @Override
            public void run() {
                if (WebRequest.this.successListener != null) {
                    WebRequest.this.successListener.onSuccess(parsedResult);
                }
            }
        });
    }

    protected void postToOriginalThread(Runnable runnable) {
        try {
            if (this.canceled) {
                return;
            }
            new Handler(this.originatingLooper).post(runnable);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public void cancel() {
        this.canceled = true;
        if (this.failOnCancel) {
            new Handler(this.originatingLooper).post(new Runnable(){

                @Override
                public void run() {
                    if (WebRequest.this.failListener != null) {
                        WebRequest.this.failListener.onFail(new RequestCanceledError(WebRequest.this.context));
                    }
                }
            });
        }
    }

    public static enum ConnectionType {
        GET,
        POST,
        PUT,
        DELETE;

    }
}

