/*
 * Decompiled with CFR 0.152.
 */
package com.guardanis.netclient;

import android.content.Context;
import com.guardanis.netclient.tools.NetUtils;
import java.net.HttpURLConnection;
import java.util.HashMap;
import java.util.Map;

public class GlobalApiRequestProperties {
    private static GlobalApiRequestProperties instance;
    private static final String PREFS = "nc__global_api_request_properties";
    private static final String PREF_KEY_PRE = "header_";
    private Context context;
    private Map<String, String> requestProperties = new HashMap<String, String>();

    public static GlobalApiRequestProperties getInstance(Context context) {
        if (instance == null) {
            instance = new GlobalApiRequestProperties(context);
        }
        return instance;
    }

    protected GlobalApiRequestProperties(Context context) {
        this.context = context.getApplicationContext();
        for (Map.Entry map : context.getSharedPreferences(PREFS, 0).getAll().entrySet()) {
            try {
                if (!((String)map.getKey()).startsWith(PREF_KEY_PRE) || String.valueOf(map.getValue()).equals("")) continue;
                this.requestProperties.put(((String)map.getKey()).substring(PREF_KEY_PRE.length()), String.valueOf(map.getValue()));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public GlobalApiRequestProperties register(String key, String value) {
        this.requestProperties.put(key, value);
        this.context.getSharedPreferences(PREFS, 0).edit().putString(PREF_KEY_PRE + key, value).commit();
        return this;
    }

    public GlobalApiRequestProperties unregister(String key) {
        this.requestProperties.remove(key);
        this.context.getSharedPreferences(PREFS, 0).edit().remove(PREF_KEY_PRE + key).commit();
        return this;
    }

    public GlobalApiRequestProperties addProperties(HttpURLConnection conn) {
        NetUtils.getInstance(this.context).addBasicAuthRequestProperty(conn);
        NetUtils.getInstance(this.context).addVersionRequestProperty(conn);
        for (String key : this.requestProperties.keySet()) {
            conn.setRequestProperty(key, this.requestProperties.get(key));
        }
        return this;
    }
}

