/*
 * Decompiled with CFR 0.152.
 */
package com.guardanis.netclient;

import android.content.Context;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.apache.http.conn.ssl.SSLSocketFactory;

public class CustomSSLSocketFactory
extends SSLSocketFactory {
    protected SSLContext currentContext = SSLContext.getInstance("TLS");

    protected CustomSSLSocketFactory(KeyStore keyStore) throws CertificateException, NoSuchAlgorithmException, KeyManagementException, KeyStoreException, UnrecoverableKeyException {
        super(null);
        this.currentContext.init(null, new TrustManager[]{new SingleX509TrustManager(keyStore)}, null);
    }

    protected CustomSSLSocketFactory() throws CertificateException, NoSuchAlgorithmException, KeyManagementException, KeyStoreException, UnrecoverableKeyException {
        super(null);
        this.currentContext.init(null, new TrustManager[]{new UnsafeX509TrustManager()}, null);
    }

    public Socket createSocket(Socket socket, String host, int port, boolean autoClose) throws IOException {
        return this.currentContext.getSocketFactory().createSocket(socket, host, port, autoClose);
    }

    public Socket createSocket() throws IOException {
        return this.currentContext.getSocketFactory().createSocket();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CustomSSLSocketFactory getInstance(Context context, int certFile, String certPass) throws CertificateException {
        try {
            KeyStore ks = KeyStore.getInstance("BKS");
            try (InputStream in = context.getResources().openRawResource(certFile);){
                ks.load(in, certPass.toCharArray());
            }
            return new CustomSSLSocketFactory(ks);
        }
        catch (Exception e) {
            throw new CertificateException(e);
        }
    }

    public static CustomSSLSocketFactory getUnsafeInstance() throws CertificateException {
        try {
            return new CustomSSLSocketFactory();
        }
        catch (Exception e) {
            throw new CertificateException(e);
        }
    }

    private class UnsafeX509TrustManager
    implements X509TrustManager {
        private boolean enableThrowCertError = false;

        protected UnsafeX509TrustManager() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            if (this.enableThrowCertError) {
                throw new CertificateException();
            }
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            if (this.enableThrowCertError) {
                throw new CertificateException();
            }
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }
    }

    private class SingleX509TrustManager
    implements X509TrustManager {
        protected List<X509TrustManager> x509TrustManagers = new ArrayList<X509TrustManager>();

        protected SingleX509TrustManager(KeyStore ... additionalkeyStores) throws CertificateException {
            ArrayList<TrustManagerFactory> factories = new ArrayList<TrustManagerFactory>();
            try {
                TrustManagerFactory original = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                original.init((KeyStore)null);
                factories.add(original);
                for (KeyStore keyStore : additionalkeyStores) {
                    TrustManagerFactory additionalCerts = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                    additionalCerts.init(keyStore);
                    factories.add(additionalCerts);
                }
            }
            catch (Exception e) {
                throw new CertificateException(e);
            }
            for (TrustManagerFactory tmf : factories) {
                for (TrustManager tm : tmf.getTrustManagers()) {
                    if (!(tm instanceof X509TrustManager)) continue;
                    this.x509TrustManagers.add((X509TrustManager)tm);
                }
            }
            if (this.x509TrustManagers.size() == 0) {
                throw new CertificateException("Couldn't find any X509TrustManagers");
            }
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            X509TrustManager defaultX509TrustManager = this.x509TrustManagers.get(0);
            defaultX509TrustManager.checkClientTrusted(chain, authType);
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            for (X509TrustManager tm : this.x509TrustManagers) {
                try {
                    tm.checkServerTrusted(chain, authType);
                    return;
                }
                catch (CertificateException certificateException) {
                }
            }
            throw new CertificateException();
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            ArrayList<X509Certificate> list = new ArrayList<X509Certificate>();
            for (X509TrustManager tm : this.x509TrustManagers) {
                list.addAll(Arrays.asList(tm.getAcceptedIssuers()));
            }
            return list.toArray(new X509Certificate[list.size()]);
        }
    }
}

