/*
 * Decompiled with CFR 0.152.
 */
package com.guardanis.imageloader.transitions.modules;

import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.support.annotation.Nullable;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import com.guardanis.imageloader.stubs.StubDrawable;
import com.guardanis.imageloader.transitions.drawables.TransitionDrawable;
import com.guardanis.imageloader.transitions.modules.TransitionModule;

public class RotationTransitionModule
extends TransitionModule {
    protected float rotateFrom;
    protected float rotateTo;
    protected float difference;

    public RotationTransitionModule(int from, int to, long duration) {
        super(duration);
        this.rotateFrom = from;
        this.rotateTo = to;
        this.difference = to - from;
        this.registerInterpolator(0, (Interpolator)new DecelerateInterpolator());
    }

    @Override
    public void onStart(@Nullable Drawable old, Drawable target) {
    }

    @Override
    public void onPredrawOld(TransitionDrawable transitionDrawable, Canvas canvas, @Nullable Drawable old, long startTime) {
    }

    @Override
    public void revertPostDrawOld(TransitionDrawable transitionDrawable, @Nullable Drawable old) {
    }

    @Override
    public void onPredrawTarget(TransitionDrawable transitionDrawable, Canvas canvas, Drawable target, long startTime) {
        if (target instanceof StubDrawable) {
            return;
        }
        float percentCompleted = this.interpolate(0, startTime);
        canvas.rotate(this.rotateFrom + percentCompleted * this.difference, (float)(transitionDrawable.getBitmap().getWidth() / 2), (float)(transitionDrawable.getBitmap().getHeight() / 2));
    }

    @Override
    public void revertPostDrawTarget(TransitionDrawable transitionDrawable, Drawable target) {
    }
}

