/*
 * Decompiled with CFR 0.152.
 */
package com.guardanis.imageloader.transitions.modules;

import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.annotation.Nullable;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import com.guardanis.imageloader.stubs.StubDrawable;
import com.guardanis.imageloader.transitions.drawables.TransitionDrawable;
import com.guardanis.imageloader.transitions.modules.TransitionModule;

public class FadingTransitionModule
extends TransitionModule {
    protected static final int TRANSITION_OUT_SPEED_MULTIPLIER = 2;
    protected int startAlpha;
    protected int endAlpha;
    protected int oldSDrawableStartingAlpha = 255;
    protected int targetSDrawableStartingAlpha = 255;

    public FadingTransitionModule(long duration) {
        this(0, 255, duration);
    }

    public FadingTransitionModule(int startAlpha, int endAlpha, long duration) {
        super(duration);
        this.startAlpha = startAlpha;
        this.endAlpha = endAlpha;
        this.registerInterpolator(1, (Interpolator)new AccelerateInterpolator());
        this.registerInterpolator(0, (Interpolator)new DecelerateInterpolator());
    }

    @Override
    public void onStart(@Nullable Drawable old, Drawable target) {
        if (Build.VERSION.SDK_INT >= 19) {
            this.oldSDrawableStartingAlpha = old.getAlpha();
            this.targetSDrawableStartingAlpha = target.getAlpha();
        }
    }

    @Override
    public void onPredrawOld(TransitionDrawable transitionDrawable, Canvas canvas, @Nullable Drawable old, long startTime) {
        if (old != null) {
            int alpha = (int)Math.max((float)this.endAlpha - (float)this.oldSDrawableStartingAlpha * this.interpolate(1, startTime) * 2.0f, 0.0f);
            int correctedAlpha = Math.min(alpha, transitionDrawable.getOverriddenMaxAlpha());
            if (old instanceof TransitionDrawable) {
                ((TransitionDrawable)old).overrideMaxAlphaOut(correctedAlpha);
            }
            old.setAlpha(correctedAlpha);
        }
    }

    @Override
    public void revertPostDrawOld(TransitionDrawable transitionDrawable, @Nullable Drawable old) {
        if (old != null) {
            old.setAlpha(this.oldSDrawableStartingAlpha);
        }
    }

    @Override
    public void onPredrawTarget(TransitionDrawable transitionDrawable, Canvas canvas, Drawable target, long startTime) {
        int alpha = (int)((float)this.startAlpha + (float)(this.endAlpha - this.startAlpha) * this.interpolate(0, startTime));
        if (target instanceof StubDrawable) {
            target.setAlpha(alpha);
        } else {
            transitionDrawable.setAlpha(alpha);
        }
    }

    @Override
    public void revertPostDrawTarget(TransitionDrawable transitionDrawable, Drawable target) {
        if (target instanceof StubDrawable) {
            target.setAlpha(this.targetSDrawableStartingAlpha);
        } else {
            transitionDrawable.setAlpha(this.targetSDrawableStartingAlpha);
        }
    }
}

