/*
 * Decompiled with CFR 0.152.
 */
package com.guardanis.imageloader;

import android.content.Context;
import android.view.View;
import com.guardanis.imageloader.ImageRequest;
import com.guardanis.imageloader.ImageUtils;
import java.io.File;

public class SVGAssetRequest<V extends View>
extends ImageRequest<V> {
    public SVGAssetRequest(Context context) {
        this(context, "");
    }

    public SVGAssetRequest(Context context, String targetUrl) {
        super(context, targetUrl);
        this.setShowStubOnExecute(false);
    }

    @Override
    protected void performFullImageRequest() {
        int requiredImageWidth = this.targetView.getLayoutParams().width;
        File imageFile = this.getEditedRequestFile();
        if (imageFile.exists()) {
            this.onRequestSuccessful(ImageUtils.decodeFile(imageFile, requiredImageWidth));
        } else {
            this.processImage(this.getEditedRequestFile(), ImageUtils.decodeSVGAsset(this.context, this.targetUrl, requiredImageWidth));
        }
    }
}

