/*
 * Decompiled with CFR 0.152.
 */
package com.guardanis.imageloader;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.support.v4.content.ContextCompat;
import android.view.View;
import android.widget.ImageView;
import com.guardanis.imageloader.ImageLoader;
import com.guardanis.imageloader.ImageUtils;
import com.guardanis.imageloader.R;
import com.guardanis.imageloader.StubHolder;
import com.guardanis.imageloader.filters.BitmapBlurFilter;
import com.guardanis.imageloader.filters.BitmapCircularCropFilter;
import com.guardanis.imageloader.filters.BitmapColorOverlayFilter;
import com.guardanis.imageloader.filters.BitmapRotationFilter;
import com.guardanis.imageloader.filters.ImageFilter;
import com.guardanis.imageloader.transitions.DefaultTransitionController;
import com.guardanis.imageloader.transitions.FadeTransitionController;
import com.guardanis.imageloader.transitions.TransitionController;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class ImageRequest<V extends View>
implements Runnable {
    protected static final int DEFAULT_BLUR_RADIUS = 15;
    protected static final int DEFAULT_CROSS_FADE_DURATION = 300;
    protected Context context;
    protected String targetUrl;
    protected V targetView;
    protected boolean setImageAsBackground = false;
    protected List<ImageFilter<Bitmap>> bitmapImageFilters = new ArrayList<ImageFilter<Bitmap>>();
    protected boolean showStubOnExecute = true;
    protected boolean showStubOnError = false;
    protected boolean disableExecutionStubIfDownloaded = true;
    protected StubHolder stubHolder;
    protected TransitionController transitionController = new DefaultTransitionController(this);

    public ImageRequest(Context context) {
        this(context, "");
    }

    public ImageRequest(Context context, String targetUrl) {
        this.context = context;
        this.targetUrl = targetUrl;
    }

    public ImageRequest<V> setTargetUrl(String targetUrl) {
        this.targetUrl = targetUrl;
        return this;
    }

    public ImageRequest<V> setTargetView(V targetView) {
        this.targetView = targetView;
        return this;
    }

    public ImageRequest<V> setImageAsBackground() {
        this.setImageAsBackground = true;
        return this;
    }

    public ImageRequest<V> setImageAsBackground(boolean setImageAsBackground) {
        this.setImageAsBackground = setImageAsBackground;
        return this;
    }

    public ImageRequest<V> setShowStubOnExecute(boolean showStubOnExecute) {
        this.showStubOnExecute = showStubOnExecute;
        return this;
    }

    public ImageRequest<V> setShowStubOnError(boolean showStubOnError) {
        this.showStubOnError = showStubOnError;
        return this;
    }

    public ImageRequest<V> setDisableExecutionStubIfDownloaded(boolean disableExecutionStubIfDownloaded) {
        this.disableExecutionStubIfDownloaded = disableExecutionStubIfDownloaded;
        return this;
    }

    public ImageRequest<V> addBlurFilter() {
        return this.addBlurFilter(15);
    }

    public ImageRequest<V> addBlurFilter(int blurRadius) {
        this.bitmapImageFilters.add(new BitmapBlurFilter(this.context, blurRadius));
        return this;
    }

    public ImageRequest<V> addColorOverlayFilter(int colorOverlay) {
        this.bitmapImageFilters.add(new BitmapColorOverlayFilter(this.context, colorOverlay));
        return this;
    }

    public ImageRequest<V> addRotationFilter(int rotationDegrees) {
        this.bitmapImageFilters.add(new BitmapRotationFilter(this.context, rotationDegrees));
        return this;
    }

    public ImageRequest<V> addCircularCropFilter() {
        this.bitmapImageFilters.add(new BitmapCircularCropFilter(this.context));
        return this;
    }

    public ImageRequest<V> addImageFilter(ImageFilter<Bitmap> imageFilter) {
        this.bitmapImageFilters.add(imageFilter);
        return this;
    }

    public ImageRequest<V> overrideStubs(StubHolder stubHolder) {
        this.stubHolder = stubHolder;
        return this;
    }

    public ImageRequest<V> setDefaultImageTransition() {
        return this.setImageTransitionController(new DefaultTransitionController(this));
    }

    public ImageRequest<V> setFadeTransition() {
        return this.setFadeTransition(300);
    }

    public ImageRequest<V> setFadeTransition(int fadeDuration) {
        return this.setImageTransitionController(new FadeTransitionController(this, fadeDuration));
    }

    public ImageRequest<V> setImageTransitionController(TransitionController controller) {
        this.transitionController = controller;
        return this;
    }

    @Override
    public void run() {
        if (this.targetView != null) {
            this.performFullImageRequest();
        }
    }

    protected void performFullImageRequest() {
        int requiredImageWidth = this.targetView.getLayoutParams().width;
        File imageFile = this.getEditedRequestFile();
        if (!imageFile.exists()) {
            File originalImageFile = this.getOriginalRequestFile();
            if (!originalImageFile.exists()) {
                this.onRequestFailed();
            } else {
                this.processImage(imageFile, ImageUtils.decodeFile(originalImageFile, requiredImageWidth));
            }
        } else {
            this.onRequestSuccessful(ImageUtils.decodeFile(imageFile, requiredImageWidth));
        }
    }

    protected void processImage(File imageFile, Bitmap bitmap) {
        if (0 < this.bitmapImageFilters.size()) {
            bitmap = this.applyBitmapFilters(bitmap);
            this.saveBitmap(imageFile, bitmap);
        }
        this.onRequestSuccessful(bitmap);
    }

    protected Bitmap applyBitmapFilters(Bitmap bitmap) {
        for (ImageFilter<Bitmap> filter : this.bitmapImageFilters) {
            bitmap = filter.filter(bitmap);
        }
        return bitmap;
    }

    protected void saveBitmap(File imageFile, Bitmap bitmap) {
        ImageUtils.saveBitmap(this.context, imageFile, bitmap);
    }

    protected void onRequestSuccessful(Bitmap bitmap) {
        if (this.targetView == null || !ImageLoader.getInstance(this.context).isViewStillUsable((View)this.targetView, this.targetUrl)) {
            return;
        }
        BitmapDrawable targetDrawable = new BitmapDrawable(this.targetView.getContext().getResources(), bitmap);
        this.transitionController.transitionTo((Drawable)targetDrawable);
    }

    protected void onRequestFailed() {
        if (this.targetView == null || !ImageLoader.getInstance(this.context).isViewStillUsable((View)this.targetView, this.targetUrl)) {
            return;
        }
        this.handleShowStubOnError();
    }

    protected void handleShowStubOnError() {
        Drawable targetDrawable = this.showStubOnError ? this.getStubs().getErrorDrawable(this.context) : ContextCompat.getDrawable((Context)this.context, (int)R.drawable.ail__default_fade_placeholder);
        this.transitionController.transitionTo(targetDrawable);
    }

    protected String getFullRequestFileCacheName() {
        String adjustedName = this.targetUrl;
        for (ImageFilter<Bitmap> filter : this.bitmapImageFilters) {
            adjustedName = adjustedName + "_" + filter.getAdjustmentInfo();
        }
        return adjustedName;
    }

    protected File getEditedRequestFile() {
        return ImageLoader.getInstance(this.context).getFileCache().getFile(this.getFullRequestFileCacheName());
    }

    protected String getOriginalRequestFileCacheName() {
        return this.targetUrl;
    }

    public Context getContext() {
        return this.context;
    }

    public boolean isSetImageAsBackgroundForced() {
        return this.setImageAsBackground;
    }

    public boolean isRequestForBackgroundImage() {
        return this.setImageAsBackground || !(this.targetView instanceof ImageView);
    }

    public V getTargetView() {
        return this.targetView;
    }

    public File getOriginalRequestFile() {
        return ImageLoader.getInstance(this.context).getFileCache().getFile(this.getOriginalRequestFileCacheName());
    }

    protected StubHolder getStubs() {
        if (this.stubHolder == null) {
            return ImageLoader.getInstance(this.context).getStubs();
        }
        return this.stubHolder;
    }

    public String getTargetUrl() {
        return this.targetUrl;
    }

    private void handleShowStubOnExecute() {
        if (this.disableExecutionStubIfDownloaded && ImageLoader.getInstance(this.context).isImageDownloaded(this)) {
            return;
        }
        Drawable targetDrawable = this.showStubOnExecute ? this.getStubs().getLoadingDrawable(this.context) : ContextCompat.getDrawable((Context)this.context, (int)R.drawable.ail__default_fade_placeholder);
        this.transitionController.transitionTo(targetDrawable);
    }

    public void execute() {
        if (this.targetView == null) {
            ImageLoader.getInstance(this.context).submit(this);
        } else {
            this.targetView.post(new Runnable(){

                @Override
                public void run() {
                    ImageLoader.getInstance(ImageRequest.this.context).addViewAndTargetUrl((View)ImageRequest.this.targetView, ImageRequest.this.targetUrl);
                    ImageRequest.this.handleShowStubOnExecute();
                    ImageLoader.getInstance(ImageRequest.this.context).submit(ImageRequest.this);
                }
            });
        }
    }
}

