/*
 * Decompiled with CFR 0.152.
 */
package com.guardanis.imageloader.transitions;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.TransitionDrawable;
import android.os.Build;
import android.support.v4.content.ContextCompat;
import android.widget.ImageView;
import com.guardanis.imageloader.ImageRequest;
import com.guardanis.imageloader.R;

public abstract class TransitionController {
    protected ImageRequest request;

    public TransitionController(ImageRequest request) {
        this.request = request;
    }

    public void transitionTo(Drawable to) {
        this.performTransition(to);
    }

    protected abstract void performTransition(Drawable var1);

    protected Drawable getCurrentTargetDrawable() {
        Drawable current;
        Drawable drawable2 = current = this.request.isRequestForBackgroundImage() ? this.request.getTargetView().getBackground() : ((ImageView)this.request.getTargetView()).getDrawable();
        if (current == null) {
            return ContextCompat.getDrawable((Context)this.request.getContext(), (int)R.drawable.ail__default_fade_placeholder);
        }
        return current instanceof TransitionDrawable ? ((TransitionDrawable)current).getDrawable(1) : current;
    }

    protected void setTargetViewDrawable(final Drawable drawable2) {
        this.request.getTargetView().post(new Runnable(){

            @Override
            public void run() {
                if (TransitionController.this.request.isRequestForBackgroundImage()) {
                    TransitionController.this.setBackgroundDrawable(drawable2);
                } else {
                    ((ImageView)TransitionController.this.request.getTargetView()).setImageDrawable(drawable2);
                }
            }
        });
    }

    @SuppressLint(value={"NewApi"})
    protected void setBackgroundDrawable(Drawable drawable2) {
        if (Build.VERSION.SDK_INT < 16) {
            this.request.getTargetView().setBackgroundDrawable(drawable2);
        } else {
            this.request.getTargetView().setBackground(drawable2);
        }
    }
}

