/*
 * Decompiled with CFR 0.152.
 */
package com.guardanis.imageloader.transitions;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;

public class FadingTransitionDrawable
extends BitmapDrawable {
    protected final int TRANSITION_OUT_SPEED_MULTIPLIER = 2;
    protected int fadeDuration;
    protected Drawable stub;
    protected long animationStart;
    protected boolean animating = false;
    protected int alpha = 255;

    public FadingTransitionDrawable(Context context, Drawable from, Bitmap to, int fadeDuration) {
        super(context.getResources(), to);
        this.stub = from;
        this.fadeDuration = fadeDuration;
        this.animating = true;
        this.animationStart = System.currentTimeMillis();
    }

    public void draw(Canvas canvas) {
        if (this.animating) {
            float normalized = (float)(System.currentTimeMillis() - this.animationStart) / (float)this.fadeDuration;
            if (1.0f <= normalized) {
                this.animating = false;
                this.stub = null;
                super.draw(canvas);
            } else {
                int partialAlpha = (int)((float)this.alpha * normalized);
                if (this.stub != null) {
                    this.drawStub(canvas, partialAlpha);
                }
                super.setAlpha(partialAlpha);
                super.draw(canvas);
                super.setAlpha(this.alpha);
                this.invalidateSelf();
            }
        } else {
            super.draw(canvas);
        }
    }

    private void drawStub(Canvas canvas, int partialAlpha) {
        canvas.save();
        int halfXDistance = (Math.max(this.getBounds().right, this.stub.getBounds().right) - Math.min(this.getBounds().right, this.stub.getBounds().right)) / 2;
        if (this.getBounds().right < this.stub.getBounds().right) {
            halfXDistance *= -1;
        }
        int halfYDistance = (Math.max(this.getBounds().bottom, this.stub.getBounds().bottom) - Math.min(this.getBounds().bottom, this.stub.getBounds().bottom)) / 2;
        if (this.getBounds().bottom < this.stub.getBounds().bottom) {
            halfYDistance *= -1;
        }
        canvas.translate((float)halfXDistance, (float)halfYDistance);
        this.stub.setAlpha(Math.max(255 - partialAlpha * 2, 0));
        this.stub.draw(canvas);
        this.stub.setAlpha(this.alpha);
        canvas.restore();
    }

    public void setAlpha(int alpha) {
        this.alpha = alpha;
    }

    public void setColorFilter(ColorFilter cf) {
    }

    public int getOpacity() {
        return -1;
    }
}

