/*
 * Decompiled with CFR 0.152.
 */
package com.guardanis.imageloader.transitions;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.widget.ImageView;
import com.guardanis.imageloader.ImageRequest;
import com.guardanis.imageloader.transitions.FadingTransitionDrawable;
import com.guardanis.imageloader.transitions.TransitionController;

public class FadeTransitionController
extends TransitionController {
    private int fadeDuration;

    public FadeTransitionController(ImageRequest request, int fadeDuration) {
        super(request);
        this.fadeDuration = fadeDuration;
    }

    @Override
    protected void performTransition(final Drawable to) {
        this.request.getTargetView().post(new Runnable(){

            @Override
            public void run() {
                FadingTransitionDrawable transition = new FadingTransitionDrawable(FadeTransitionController.this.request.getContext(), FadeTransitionController.this.getCurrentTargetDrawable().getConstantState().newDrawable().mutate(), FadeTransitionController.this.getTargetBitmap(to), FadeTransitionController.this.fadeDuration);
                FadeTransitionController.this.setTransitionDrawable((Drawable)transition);
            }
        });
    }

    private void setTransitionDrawable(Drawable drawable2) {
        if (this.request.isRequestForBackgroundImage()) {
            this.setBackgroundDrawable(drawable2);
        } else {
            ((ImageView)this.request.getTargetView()).setImageDrawable(drawable2);
        }
    }

    private Bitmap getTargetBitmap(Drawable drawable2) {
        if (drawable2 instanceof BitmapDrawable) {
            return ((BitmapDrawable)drawable2).getBitmap();
        }
        Bitmap bitmap = null;
        if (drawable2.getIntrinsicWidth() < 1 || drawable2.getIntrinsicHeight() < 1) {
            bitmap = Bitmap.createBitmap((int)1, (int)1, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        } else {
            Bitmap.createBitmap((int)drawable2.getIntrinsicWidth(), (int)drawable2.getIntrinsicHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        }
        Canvas canvas = new Canvas(bitmap);
        drawable2.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
        drawable2.draw(canvas);
        return bitmap;
    }
}

