/*
 * Decompiled with CFR 0.152.
 */
package com.gu.toolargetool;

import android.os.Bundle;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentManager;
import com.gu.toolargetool.Formatter;
import com.gu.toolargetool.Logger;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0018\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000f\u001a\u00020\u000bH\u0016J \u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\fH\u0016J\u0018\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000f\u001a\u00020\u000bH\u0016J\r\u0010\u0016\u001a\u00020\u000eH\u0000\u00a2\u0006\u0002\b\u0017J\r\u0010\u0018\u001a\u00020\u000eH\u0000\u00a2\u0006\u0002\b\u0019R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0006\u0012\u0004\u0018\u00010\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/gu/toolargetool/FragmentSavedStateLogger;", "Landroidx/fragment/app/FragmentManager$FragmentLifecycleCallbacks;", "formatter", "Lcom/gu/toolargetool/Formatter;", "logger", "Lcom/gu/toolargetool/Logger;", "(Lcom/gu/toolargetool/Formatter;Lcom/gu/toolargetool/Logger;)V", "isLogging", "", "savedStates", "Ljava/util/HashMap;", "Landroidx/fragment/app/Fragment;", "Landroid/os/Bundle;", "logAndRemoveSavedState", "", "f", "fm", "Landroidx/fragment/app/FragmentManager;", "onFragmentDestroyed", "onFragmentSaveInstanceState", "outState", "onFragmentStopped", "startLogging", "startLogging$toolargetool_release", "stopLogging", "stopLogging$toolargetool_release", "toolargetool_release"})
public final class FragmentSavedStateLogger
extends FragmentManager.FragmentLifecycleCallbacks {
    @NotNull
    private final Formatter formatter;
    @NotNull
    private final Logger logger;
    @NotNull
    private final HashMap<Fragment, Bundle> savedStates;
    private boolean isLogging;

    public FragmentSavedStateLogger(@NotNull Formatter formatter, @NotNull Logger logger) {
        Intrinsics.checkNotNullParameter((Object)formatter, (String)"formatter");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.formatter = formatter;
        this.logger = logger;
        this.savedStates = new HashMap();
        this.isLogging = true;
    }

    public void onFragmentSaveInstanceState(@NotNull FragmentManager fm, @NotNull Fragment f, @NotNull Bundle outState) {
        Intrinsics.checkNotNullParameter((Object)fm, (String)"fm");
        Intrinsics.checkNotNullParameter((Object)f, (String)"f");
        Intrinsics.checkNotNullParameter((Object)outState, (String)"outState");
        if (this.isLogging) {
            ((Map)this.savedStates).put(f, outState);
        }
    }

    public void onFragmentStopped(@NotNull FragmentManager fm, @NotNull Fragment f) {
        Intrinsics.checkNotNullParameter((Object)fm, (String)"fm");
        Intrinsics.checkNotNullParameter((Object)f, (String)"f");
        this.logAndRemoveSavedState(f, fm);
    }

    public void onFragmentDestroyed(@NotNull FragmentManager fm, @NotNull Fragment f) {
        Intrinsics.checkNotNullParameter((Object)fm, (String)"fm");
        Intrinsics.checkNotNullParameter((Object)f, (String)"f");
        this.logAndRemoveSavedState(f, fm);
    }

    private final void logAndRemoveSavedState(Fragment f, FragmentManager fm) {
        Bundle savedState = this.savedStates.remove(f);
        if (savedState != null) {
            try {
                String message = this.formatter.format(fm, f, savedState);
                this.logger.log(message);
            }
            catch (RuntimeException e) {
                this.logger.logException(e);
            }
        }
    }

    public final void startLogging$toolargetool_release() {
        this.isLogging = true;
    }

    public final void stopLogging$toolargetool_release() {
        this.isLogging = false;
    }
}

