/*
 * Decompiled with CFR 0.152.
 */
package com.growingio.android.sdk.track.webservices.widget;

import android.app.Activity;
import android.content.Context;
import android.os.IBinder;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.WindowManager;
import android.widget.FrameLayout;
import android.widget.TextView;
import androidx.annotation.StringRes;
import com.growingio.android.sdk.track.R;
import com.growingio.android.sdk.track.utils.DeviceUtil;

public class TipView
extends FrameLayout {
    private final Context mContext;
    private final WindowManager mWindowManager;
    private TextView mContent;
    private TextView mDragTip;
    private boolean mIsShowing = false;
    private boolean mIsDismissed = false;
    private int mMinMoveDistance;
    private int mViewLastY;
    private float mTouchDownY;

    public TipView(Context context) {
        super(context);
        this.mContext = context;
        this.mWindowManager = (WindowManager)this.mContext.getSystemService("window");
        this.createView();
        this.setKeepScreenOn(true);
    }

    private void createView() {
        this.mContent = new TextView(this.getContext());
        this.mDragTip = new TextView(this.getContext());
        this.mDragTip.setGravity(5);
        this.mContent.setTextSize(2, 14.0f);
        this.mDragTip.setTextSize(2, 12.0f);
        int padding = DeviceUtil.dp2Px(this.getContext(), 4.0f);
        int paddingVertical = DeviceUtil.dp2Px(this.getContext(), 6.0f);
        int paddingHorizontal = DeviceUtil.dp2Px(this.getContext(), 8.0f);
        this.mContent.setPadding(paddingHorizontal, padding, paddingHorizontal, padding);
        this.mDragTip.setPadding(paddingHorizontal, paddingVertical, paddingHorizontal, paddingVertical);
        this.mContent.setTextColor(-1);
        this.mDragTip.setTextColor(-1);
        this.mDragTip.setText((CharSequence)"\u5982\u6709\u906e\u6321\u8bf7\u62d6\u52a8\u6b64\u6761");
        this.addView((View)this.mContent, new ViewGroup.LayoutParams(-1, -2));
        this.addView((View)this.mDragTip, new ViewGroup.LayoutParams(-1, -1));
        this.setBackgroundResource(R.color.growing_tracker_blue);
        this.mViewLastY = this.getStatusBarHeight();
        this.mMinMoveDistance = ViewConfiguration.get((Context)this.mContext).getScaledTouchSlop();
    }

    public void setContent(@StringRes int resid) {
        this.setContent(this.getContext().getResources().getText(resid));
    }

    public void setContent(CharSequence content) {
        this.mDragTip.setVisibility(0);
        this.mContent.setGravity(3);
        this.setBackgroundResource(R.color.growing_tracker_blue);
        this.mContent.setText(content);
    }

    public void setErrorMessage(@StringRes int resid) {
        this.setErrorMessage(this.getContext().getResources().getText(resid));
    }

    public void setErrorMessage(CharSequence message) {
        this.mDragTip.setVisibility(8);
        this.mContent.setGravity(17);
        this.setBackgroundResource(R.color.growing_tracker_orange);
        this.mContent.setText(message);
    }

    public boolean onTouchEvent(MotionEvent event) {
        switch (event.getAction()) {
            case 0: {
                this.mTouchDownY = event.getRawY();
                break;
            }
            case 2: {
                float rawY = event.getRawY();
                if (Math.abs(rawY - this.mTouchDownY) < (float)this.mMinMoveDistance) break;
                int offsetY = (int)(rawY - (float)this.mViewLastY);
                WindowManager.LayoutParams layoutParams = (WindowManager.LayoutParams)this.getLayoutParams();
                layoutParams.y += offsetY;
                this.mViewLastY = layoutParams.y;
                this.mWindowManager.updateViewLayout((View)this, (ViewGroup.LayoutParams)layoutParams);
                break;
            }
            case 1: 
            case 3: {
                if (!(Math.abs(event.getRawY() - this.mTouchDownY) < (float)this.mMinMoveDistance)) break;
                this.performClick();
                break;
            }
        }
        return true;
    }

    public int getStatusBarHeight() {
        int result = 0;
        int resourceId = this.getResources().getIdentifier("status_bar_height", "dimen", "android");
        if (resourceId > 0) {
            result = this.getResources().getDimensionPixelSize(resourceId);
        }
        return result;
    }

    public void show(final Activity activity) {
        if (this.isDismissed()) {
            return;
        }
        WindowManager.LayoutParams layoutParams = new WindowManager.LayoutParams();
        layoutParams.type = 1000;
        final View decorView = activity.getWindow().getDecorView();
        IBinder windowToken = decorView.getWindowToken();
        if (windowToken == null) {
            decorView.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

                public void onGlobalLayout() {
                    IBinder token = activity.getWindow().getDecorView().getWindowToken();
                    if (token != null) {
                        TipView.this.addView(token);
                        decorView.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                    }
                }
            });
        } else {
            this.addView(windowToken);
        }
    }

    private void addView(IBinder windowToken) {
        if (!this.mIsShowing) {
            this.mIsShowing = true;
            WindowManager.LayoutParams layoutParams = new WindowManager.LayoutParams();
            layoutParams.type = 1000;
            layoutParams.token = windowToken;
            layoutParams.width = -1;
            layoutParams.height = -2;
            layoutParams.flags = 262184;
            layoutParams.gravity = 51;
            layoutParams.y = this.mViewLastY;
            this.mWindowManager.addView((View)this, (ViewGroup.LayoutParams)layoutParams);
        }
    }

    public void remove() {
        if (this.mIsShowing) {
            WindowManager windowManager = (WindowManager)this.getContext().getSystemService("window");
            windowManager.removeView((View)this);
            this.mIsShowing = false;
        }
    }

    public void dismiss() {
        this.mIsDismissed = true;
        this.remove();
    }

    public void show() {
        this.mIsDismissed = false;
    }

    public boolean isDismissed() {
        return this.mIsDismissed;
    }
}

