/*
 * Decompiled with CFR 0.152.
 */
package com.growingio.android.sdk.track.webservices.message;

import android.content.Context;
import android.util.DisplayMetrics;
import com.growingio.android.sdk.TrackerContext;
import com.growingio.android.sdk.track.log.Logger;
import com.growingio.android.sdk.track.providers.AppInfoProvider;
import com.growingio.android.sdk.track.providers.ConfigurationProvider;
import com.growingio.android.sdk.track.utils.DeviceUtil;
import org.json.JSONException;
import org.json.JSONObject;

public class ReadyMessage {
    public static final String MSG_TYPE = "ready";
    private final String mProjectId;
    private final String mMsgType;
    private final long mTimestamp = System.currentTimeMillis();
    private final String mDomain;
    private final String mSdkVersion;
    private final int mSdkVersionCode;
    private final String mOs;
    private final int mScreenWidth;
    private final int mScreenHeight;
    private final String mUrlScheme;

    private ReadyMessage(String projectId, String domain, String sdkVersion, int sdkVersionCode, int screenWidth, int screenHeight, String urlScheme) {
        this.mMsgType = MSG_TYPE;
        this.mOs = "Android";
        this.mProjectId = projectId;
        this.mDomain = domain;
        this.mSdkVersion = sdkVersion;
        this.mSdkVersionCode = sdkVersionCode;
        this.mScreenWidth = screenWidth;
        this.mScreenHeight = screenHeight;
        this.mUrlScheme = urlScheme;
    }

    public static ReadyMessage createMessage() {
        Context context = TrackerContext.get().getApplicationContext();
        String projectId = ConfigurationProvider.core().getProjectId();
        String domain = AppInfoProvider.get().getPackageName();
        String sdkVersion = "3.3.6";
        int sdkVersionCode = 30306;
        DisplayMetrics metrics = DeviceUtil.getDisplayMetrics(context);
        String urlScheme = ConfigurationProvider.core().getUrlScheme();
        return new ReadyMessage(projectId, domain, sdkVersion, sdkVersionCode, metrics.widthPixels, metrics.heightPixels, urlScheme);
    }

    public JSONObject toJSONObject() {
        JSONObject json = new JSONObject();
        try {
            json.put("projectId", (Object)this.mProjectId);
            json.put("msgType", (Object)this.mMsgType);
            json.put("timestamp", this.mTimestamp);
            json.put("domain", (Object)this.mDomain);
            json.put("sdkVersion", (Object)this.mSdkVersion);
            json.put("sdkVersionCode", this.mSdkVersionCode);
            json.put("os", (Object)this.mOs);
            json.put("screenWidth", this.mScreenWidth);
            json.put("screenHeight", this.mScreenHeight);
            json.put("urlScheme", (Object)this.mUrlScheme);
            Logger.d("READY MESSAGE", json.toString(), new Object[0]);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return json;
    }
}

