/*
 * Decompiled with CFR 0.152.
 */
package com.growingio.android.sdk.track.webservices.message;

import com.growingio.android.sdk.track.providers.AppInfoProvider;
import com.growingio.android.sdk.track.providers.DeviceInfoProvider;
import org.json.JSONException;
import org.json.JSONObject;

public class ClientInfoMessage {
    public static final String MSG_TYPE = "client_info";
    private final String mMsgType;
    private final String mSdkVersion;
    private final JSONObject mData = new JSONObject();

    public ClientInfoMessage(String sdkVersion, String os, String appVersion, String appChannel, String osVersion, String deviceType, String deviceBrand, String deviceModel) {
        this.mMsgType = MSG_TYPE;
        this.mSdkVersion = sdkVersion;
        try {
            this.mData.put("os", (Object)os);
            this.mData.put("appVersion", (Object)appVersion);
            this.mData.put("appChannel", (Object)appChannel);
            this.mData.put("osVersion", (Object)osVersion);
            this.mData.put("deviceType", (Object)deviceType);
            this.mData.put("deviceBrand", (Object)deviceBrand);
            this.mData.put("deviceModel", (Object)deviceModel);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    public static ClientInfoMessage createMessage() {
        DeviceInfoProvider deviceInfo = DeviceInfoProvider.get();
        AppInfoProvider appInfo = AppInfoProvider.get();
        return new ClientInfoMessage("3.3.6", "Android", appInfo.getAppVersion(), appInfo.getAppChannel(), deviceInfo.getOperatingSystemVersion(), deviceInfo.getDeviceType(), deviceInfo.getDeviceBrand(), deviceInfo.getDeviceModel());
    }

    public JSONObject toJSONObject() {
        JSONObject json = new JSONObject();
        try {
            json.put("msgType", (Object)this.mMsgType);
            json.put("sdkVersion", (Object)this.mSdkVersion);
            json.put("data", (Object)this.mData);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return json;
    }
}

