/*
 * Decompiled with CFR 0.152.
 */
package com.growingio.android.sdk.track.webservices.log;

import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import com.growingio.android.sdk.track.log.CacheLogger;
import com.growingio.android.sdk.track.log.ILogger;
import com.growingio.android.sdk.track.log.LogItem;
import com.growingio.android.sdk.track.log.Logger;
import com.growingio.android.sdk.track.webservices.log.LoggerDataMessage;
import java.util.List;

public class WsLogger {
    public static final String TYPE = "WsLogger";
    private volatile Callback mCallback;
    private static Handler sLogHandler;
    private CacheLogger mCacheLogger;
    private final Runnable mLogRunnable = this::printOut;

    public WsLogger() {
        ILogger cacheLogger = Logger.getLogger("CacheLogger");
        if (cacheLogger instanceof CacheLogger) {
            this.mCacheLogger = (CacheLogger)cacheLogger;
        }
    }

    public void setCallback(Callback callback) {
        this.mCallback = callback;
    }

    public void openLog() {
        if (sLogHandler == null) {
            HandlerThread logHt = new HandlerThread(TYPE);
            logHt.start();
            sLogHandler = new Handler(logHt.getLooper());
        }
        sLogHandler.postDelayed(this.mLogRunnable, 500L);
    }

    public void closeLog() {
        if (sLogHandler != null) {
            sLogHandler.removeCallbacks(this.mLogRunnable);
        }
    }

    public void printOut() {
        List<LogItem> mLoggers;
        if (Looper.myLooper() != sLogHandler.getLooper()) {
            sLogHandler.post(this.mLogRunnable);
            return;
        }
        if (this.mCacheLogger != null && (mLoggers = this.mCacheLogger.getCacheLogsAndClear()) != null && !mLoggers.isEmpty() && this.mCallback != null) {
            String loggerData = LoggerDataMessage.createTrackMessage(mLoggers).toJSONObject().toString();
            this.mCallback.disposeLog(loggerData);
        }
        sLogHandler.removeCallbacks(this.mLogRunnable);
        sLogHandler.postDelayed(this.mLogRunnable, 500L);
    }

    public static interface Callback {
        public void disposeLog(String var1);
    }
}

