/*
 * Decompiled with CFR 0.152.
 */
package com.growingio.android.sdk.track.webservices.log;

import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class LoggerDataMessage {
    public static final String MSG_TYPE = "logger_data";
    private List<LogItem> mLogs;
    private final String mMsgType;

    private LoggerDataMessage(List<LogItem> logs) {
        this.mMsgType = MSG_TYPE;
        this.mLogs = logs;
    }

    public static LoggerDataMessage createTrackMessage(List<com.growingio.android.sdk.track.log.LogItem> logs) {
        ArrayList<LogItem> list = new ArrayList<LogItem>(logs.size());
        for (int i = 0; i < logs.size(); ++i) {
            com.growingio.android.sdk.track.log.LogItem logItem = logs.get(i);
            list.add(LogItem.create(LoggerDataMessage.priorityToState(logItem.getPriority()), "subType", logItem.getMessage(), logItem.getTimeStamp()));
        }
        return new LoggerDataMessage(list);
    }

    public JSONObject toJSONObject() {
        JSONObject json = new JSONObject();
        try {
            json.put("msgType", (Object)this.mMsgType);
            json.put("sdkVersion", (Object)"3.3.6");
            JSONArray logs = new JSONArray();
            for (LogItem logItem : this.mLogs) {
                logs.put((Object)logItem.toJSONObject());
            }
            json.put("data", (Object)logs);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return json;
    }

    private static String priorityToState(int priority) {
        switch (priority) {
            case 2: {
                return "VERBOSE";
            }
            case 3: {
                return "DEBUG";
            }
            case 4: {
                return "INFO";
            }
            case 5: {
                return "WARN";
            }
            case 6: {
                return "ERROR";
            }
            case 7: {
                return "ALARM";
            }
        }
        return "OTHER";
    }

    public static class LogItem {
        private final String mType;
        private final String mSubType;
        private final String mMessage;
        private final long mTime;

        public LogItem(String type, String subType, String message, long time) {
            this.mType = type;
            this.mSubType = subType;
            this.mMessage = message;
            this.mTime = time;
        }

        public static LogItem create(String type, String subType, String message, long time) {
            return new LogItem(type, subType, message, time);
        }

        public JSONObject toJSONObject() {
            JSONObject json = new JSONObject();
            try {
                json.put("type", (Object)this.mType);
                json.put("subType", (Object)this.mSubType);
                json.put("message", (Object)this.mMessage);
                json.put("time", this.mTime);
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
            return json;
        }
    }
}

