/*
 * Decompiled with CFR 0.152.
 */
package com.growingio.android.sdk.track.view;

import android.annotation.SuppressLint;
import android.view.View;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;

public class WindowManagerShadow {
    private static final String TAG = "WindowManagerShadow";
    private final Object mRealWindowManager;
    private final Field mViews;
    private final boolean mIsArrayList;

    @SuppressLint(value={"PrivateApi"})
    public WindowManagerShadow(String wmClassName) throws ClassNotFoundException, NoSuchFieldException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        Class<?> windowManager = Class.forName(wmClassName);
        Method method = windowManager.getMethod("getInstance", new Class[0]);
        method.setAccessible(true);
        this.mRealWindowManager = method.invoke(null, new Object[0]);
        this.mViews = windowManager.getDeclaredField("mViews");
        this.mViews.setAccessible(true);
        this.mIsArrayList = this.mViews.getType() == ArrayList.class;
    }

    public View[] getAllWindowViews() throws IllegalAccessException {
        View[] views = this.mIsArrayList ? ((ArrayList)this.mViews.get(this.mRealWindowManager)).toArray(new View[0]) : (View[])this.mViews.get(this.mRealWindowManager);
        return views;
    }
}

