/*
 * Decompiled with CFR 0.152.
 */
package com.growingio.android.sdk.track.view;

import android.app.Activity;
import android.graphics.Rect;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.View;
import android.view.WindowManager;
import com.growingio.android.sdk.track.log.Logger;
import com.growingio.android.sdk.track.providers.ActivityStateProvider;
import com.growingio.android.sdk.track.view.DecorView;
import com.growingio.android.sdk.track.view.WindowManagerShadow;
import java.util.ArrayList;
import java.util.List;

public class WindowHelper {
    private static final String TAG = "WindowHelper";
    private final WindowManagerShadow mWindowManager;

    private WindowHelper() {
        WindowManagerShadow managerShadow = null;
        try {
            managerShadow = new WindowManagerShadow("android.view.WindowManagerGlobal");
        }
        catch (Exception e) {
            Logger.e(TAG, e);
        }
        this.mWindowManager = managerShadow;
    }

    public static WindowHelper get() {
        return SingleInstance.INSTANCE;
    }

    public boolean isDecorView(View rootView) {
        return !(rootView.getParent() instanceof View);
    }

    @NonNull
    public List<DecorView> getTopActivityViews() {
        ArrayList<DecorView> topViews = new ArrayList<DecorView>();
        Activity activity = ActivityStateProvider.get().getForegroundActivity();
        if (activity == null) {
            return topViews;
        }
        List<DecorView> decorViews = this.getAllWindowDecorViews();
        boolean findTopActivity = false;
        for (DecorView decorView : decorViews) {
            View view = decorView.getView();
            if (view == activity.getWindow().getDecorView() || view.getContext() == activity) {
                topViews.add(decorView);
                findTopActivity = true;
                continue;
            }
            if (!findTopActivity) continue;
            topViews.add(decorView);
        }
        return topViews;
    }

    public List<DecorView> getAllWindowDecorViews() {
        View[] allViews;
        ArrayList<DecorView> decorViews = new ArrayList<DecorView>();
        for (View view : allViews = WindowHelper.get().getWindowViews()) {
            int[] location = new int[2];
            view.getLocationOnScreen(location);
            int x = location[0];
            int y = location[1];
            Rect area = new Rect(x, y, x + view.getWidth(), y + view.getHeight());
            if (!(view.getLayoutParams() instanceof WindowManager.LayoutParams)) continue;
            WindowManager.LayoutParams windowParams = (WindowManager.LayoutParams)view.getLayoutParams();
            decorViews.add(new DecorView(view, area, windowParams));
        }
        return decorViews;
    }

    @Nullable
    public View getTopActivityDecorView() {
        Activity current = ActivityStateProvider.get().getForegroundActivity();
        if (current != null) {
            try {
                return current.getWindow().getDecorView();
            }
            catch (Exception e) {
                Logger.e(TAG, e);
            }
        }
        return null;
    }

    private View[] getWindowViews() {
        View decorView;
        if (this.mWindowManager != null) {
            try {
                return this.mWindowManager.getAllWindowViews();
            }
            catch (IllegalAccessException e) {
                Logger.e(TAG, e);
            }
        }
        if ((decorView = this.getTopActivityDecorView()) != null) {
            return new View[]{decorView};
        }
        return new View[0];
    }

    private static class SingleInstance {
        private static final WindowHelper INSTANCE = new WindowHelper();

        private SingleInstance() {
        }
    }
}

