/*
 * Decompiled with CFR 0.152.
 */
package com.growingio.android.sdk.track.view;

import android.app.Activity;
import android.os.Build;
import android.view.View;
import android.view.ViewTreeObserver;
import androidx.annotation.RequiresApi;
import com.growingio.android.sdk.track.R;
import com.growingio.android.sdk.track.listener.IActivityLifecycle;
import com.growingio.android.sdk.track.listener.ListenerContainer;
import com.growingio.android.sdk.track.listener.event.ActivityLifecycleEvent;
import com.growingio.android.sdk.track.providers.ActivityStateProvider;
import com.growingio.android.sdk.track.view.OnViewStateChangedListener;
import com.growingio.android.sdk.track.view.ViewStateChangedEvent;

public class ViewTreeStatusProvider
extends ListenerContainer<OnViewStateChangedListener, ViewStateChangedEvent>
implements IActivityLifecycle {
    private static final String TAG = "ViewTreeStatusProvider";
    private final DeprecatedViewStateObserver mViewStateObserver;

    public static ViewTreeStatusProvider get() {
        return SingleInstance.INSTANCE;
    }

    public ViewTreeStatusProvider() {
        ActivityStateProvider.get().registerActivityLifecycleListener(this);
        this.mViewStateObserver = Build.VERSION.SDK_INT >= 18 ? new ViewStateObserver() : new DeprecatedViewStateObserver();
    }

    @Override
    protected void singleAction(OnViewStateChangedListener listener, ViewStateChangedEvent event) {
        listener.onViewStateChanged(event);
    }

    @Override
    public void onActivityLifecycle(ActivityLifecycleEvent event) {
        Activity activity = event.getActivity();
        if (event.eventType == ActivityLifecycleEvent.EVENT_TYPE.ON_RESUMED) {
            this.monitorViewTreeChange(activity.getWindow().getDecorView());
        } else if (event.eventType == ActivityLifecycleEvent.EVENT_TYPE.ON_PAUSED) {
            this.unRegisterViewTreeChange(activity.getWindow().getDecorView());
        }
    }

    private void unRegisterViewTreeChange(View root) {
        if (ViewTreeStatusProvider.isMonitoringViewTree(root)) {
            root.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this.mViewStateObserver);
            root.getViewTreeObserver().removeOnGlobalFocusChangeListener((ViewTreeObserver.OnGlobalFocusChangeListener)this.mViewStateObserver);
            root.getViewTreeObserver().removeOnScrollChangedListener((ViewTreeObserver.OnScrollChangedListener)this.mViewStateObserver);
            if (Build.VERSION.SDK_INT >= 18) {
                root.getViewTreeObserver().removeOnWindowFocusChangeListener((ViewTreeObserver.OnWindowFocusChangeListener)this.mViewStateObserver);
            }
            ViewTreeStatusProvider.setMonitoringViewTreeEnabled(root, false);
        }
    }

    private void monitorViewTreeChange(View root) {
        if (!ViewTreeStatusProvider.isMonitoringViewTree(root)) {
            root.getViewTreeObserver().addOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this.mViewStateObserver);
            root.getViewTreeObserver().addOnScrollChangedListener((ViewTreeObserver.OnScrollChangedListener)this.mViewStateObserver);
            root.getViewTreeObserver().addOnGlobalFocusChangeListener((ViewTreeObserver.OnGlobalFocusChangeListener)this.mViewStateObserver);
            if (Build.VERSION.SDK_INT >= 18) {
                root.getViewTreeObserver().addOnWindowFocusChangeListener((ViewTreeObserver.OnWindowFocusChangeListener)this.mViewStateObserver);
            }
            ViewTreeStatusProvider.setMonitoringViewTreeEnabled(root, true);
        }
    }

    public static void setMonitoringViewTreeEnabled(View view, boolean monitoring) {
        if (monitoring) {
            view.setTag(R.id.growing_tracker_monitoring_view_tree_enabled, new Object());
        } else {
            view.setTag(R.id.growing_tracker_monitoring_view_tree_enabled, null);
        }
    }

    public static boolean isMonitoringViewTree(View view) {
        Object monitoring = view.getTag(R.id.growing_tracker_monitoring_view_tree_enabled);
        return monitoring != null;
    }

    @RequiresApi(api=18)
    private static class ViewStateObserver
    extends DeprecatedViewStateObserver
    implements ViewTreeObserver.OnWindowFocusChangeListener {
        private ViewStateObserver() {
        }

        public void onWindowFocusChanged(boolean hasFocus) {
            ViewTreeStatusProvider.get().dispatchActions(new ViewStateChangedEvent(ViewStateChangedEvent.StateType.WINDOW_FOCUS_CHANGED));
        }
    }

    private static class DeprecatedViewStateObserver
    implements ViewTreeObserver.OnGlobalLayoutListener,
    ViewTreeObserver.OnScrollChangedListener,
    ViewTreeObserver.OnGlobalFocusChangeListener {
        private DeprecatedViewStateObserver() {
        }

        public void onGlobalFocusChanged(View oldFocus, View newFocus) {
            ViewTreeStatusProvider.get().dispatchActions(new ViewStateChangedEvent(ViewStateChangedEvent.StateType.FOCUS_CHANGED, oldFocus, newFocus));
        }

        public void onGlobalLayout() {
            ViewTreeStatusProvider.get().dispatchActions(new ViewStateChangedEvent(ViewStateChangedEvent.StateType.LAYOUT_CHANGED));
        }

        public void onScrollChanged() {
            ViewTreeStatusProvider.get().dispatchActions(new ViewStateChangedEvent(ViewStateChangedEvent.StateType.SCROLL_CHANGED));
        }
    }

    private static class SingleInstance {
        private static final ViewTreeStatusProvider INSTANCE = new ViewTreeStatusProvider();

        private SingleInstance() {
        }
    }
}

