/*
 * Decompiled with CFR 0.152.
 */
package com.growingio.android.sdk.track.view;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.util.Base64;
import android.util.DisplayMetrics;
import com.growingio.android.sdk.TrackerContext;
import com.growingio.android.sdk.track.utils.DeviceUtil;
import com.growingio.android.sdk.track.view.DecorView;
import com.growingio.android.sdk.track.view.WindowHelper;
import com.growingio.android.sdk.track.webservices.widget.TipView;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;

public class ScreenshotUtil {
    private ScreenshotUtil() {
    }

    public static String getScreenshotBase64(float scale) throws IOException {
        Bitmap screenshotBitmap = ScreenshotUtil.getScreenshotBitmap(scale);
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        screenshotBitmap.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)stream);
        stream.flush();
        stream.close();
        screenshotBitmap.recycle();
        byte[] bitmapBytes = stream.toByteArray();
        return "data:image/jpeg;base64," + Base64.encodeToString((byte[])bitmapBytes, (int)0);
    }

    public static Bitmap getScreenshotBitmap(float scale) {
        Bitmap originBitmap = ScreenshotUtil.getScreenshotBitmap();
        Matrix matrix = new Matrix();
        matrix.postScale(scale, scale);
        Bitmap newBitmap = Bitmap.createBitmap((Bitmap)originBitmap, (int)0, (int)0, (int)originBitmap.getWidth(), (int)originBitmap.getHeight(), (Matrix)matrix, (boolean)false);
        if (newBitmap.equals(originBitmap)) {
            return originBitmap;
        }
        originBitmap.recycle();
        return newBitmap;
    }

    public static Bitmap getScreenshotBitmap() {
        List<DecorView> decorViews = WindowHelper.get().getTopActivityViews();
        for (int i = decorViews.size() - 1; i >= 0; --i) {
            if (!(decorViews.get(i).getView() instanceof TipView)) continue;
            decorViews.remove(i);
            break;
        }
        DisplayMetrics metrics = DeviceUtil.getDisplayMetrics(TrackerContext.get().getApplicationContext());
        Bitmap bitmap = Bitmap.createBitmap((int)metrics.widthPixels, (int)metrics.heightPixels, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        ScreenshotUtil.drawDecorViewsToBitmap(decorViews, bitmap);
        return bitmap;
    }

    private static void drawDecorViewsToBitmap(List<DecorView> decorViews, Bitmap bitmap) {
        if (null != decorViews) {
            for (DecorView decorView : decorViews) {
                ScreenshotUtil.drawDecorViewToBitmap(decorView, bitmap);
            }
        }
    }

    private static void drawDecorViewToBitmap(DecorView decorView, Bitmap bitmap) {
        if ((decorView.getLayoutParams().flags & 2) == 2) {
            Canvas dimCanvas = new Canvas(bitmap);
            int alpha = (int)(255.0f * decorView.getLayoutParams().dimAmount);
            dimCanvas.drawARGB(alpha, 0, 0, 0);
        }
        Canvas canvas = new Canvas(bitmap);
        canvas.translate((float)decorView.getRect().left, (float)decorView.getRect().top);
        decorView.getView().draw(canvas);
    }
}

