/*
 * Decompiled with CFR 0.152.
 */
package com.growingio.android.sdk.track.utils;

import android.os.Handler;
import android.os.Looper;

public class ThreadUtils {
    private static final Object LOCK = new Object();
    private static boolean sWillOverride = false;
    private static Handler sUiThreadHandler = null;

    private ThreadUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setWillOverrideUiThread() {
        Object object = LOCK;
        synchronized (object) {
            sWillOverride = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setUiThread(Looper looper) {
        Object object = LOCK;
        synchronized (object) {
            if (sUiThreadHandler != null && sUiThreadHandler.getLooper() != looper) {
                throw new RuntimeException("UI thread looper is already set to " + sUiThreadHandler.getLooper() + " (Main thread looper is " + Looper.getMainLooper() + "), cannot set to new looper " + looper);
            }
            sUiThreadHandler = new Handler(looper);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Handler getUiThreadHandler() {
        Object object = LOCK;
        synchronized (object) {
            if (sUiThreadHandler == null) {
                if (sWillOverride) {
                    throw new RuntimeException("Did not yet override the UI thread");
                }
                sUiThreadHandler = new Handler(Looper.getMainLooper());
            }
            return sUiThreadHandler;
        }
    }

    public static void runOnUiThread(Runnable r) {
        if (ThreadUtils.runningOnUiThread()) {
            r.run();
        } else {
            ThreadUtils.getUiThreadHandler().post(r);
        }
    }

    public static void postOnUiThreadDelayed(Runnable task, long delayMillis) {
        ThreadUtils.getUiThreadHandler().postDelayed(task, delayMillis);
    }

    public static boolean runningOnUiThread() {
        return ThreadUtils.getUiThreadHandler().getLooper() == Looper.myLooper();
    }
}

