/*
 * Decompiled with CFR 0.152.
 */
package com.growingio.android.sdk.track.utils;

import android.app.Application;
import android.content.Context;
import android.os.Build;
import android.os.Process;
import android.text.TextUtils;
import com.growingio.android.sdk.track.log.Logger;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class SystemUtil {
    private static final String TAG = "SystemUtil";

    private SystemUtil() {
    }

    public static String getProcessName() {
        if (Build.VERSION.SDK_INT >= 28) {
            return Application.getProcessName();
        }
        String processName = null;
        try {
            Class<?> activityThread = Class.forName("android.app.ActivityThread");
            String methodName = Build.VERSION.SDK_INT >= 18 ? "currentProcessName" : "currentPackageName";
            Method getProcessName = activityThread.getDeclaredMethod(methodName, new Class[0]);
            processName = (String)getProcessName.invoke(null, new Object[0]);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        if (processName == null) {
            try (BufferedReader mBufferedReader = new BufferedReader(new FileReader(new File("/proc/" + Process.myPid() + "/cmdline")));){
                processName = mBufferedReader.readLine().trim();
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException(e);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return processName;
    }

    public static boolean isMainProcess(Context context) {
        try {
            String processName = SystemUtil.getProcessName();
            return !TextUtils.isEmpty((CharSequence)processName) && processName.equals(context.getPackageName());
        }
        catch (Exception e) {
            Logger.e(TAG, e);
            return false;
        }
    }
}

