/*
 * Decompiled with CFR 0.152.
 */
package com.growingio.android.sdk.track.utils;

import android.content.Context;
import android.content.pm.PackageManager;
import com.growingio.android.sdk.TrackerContext;
import com.growingio.android.sdk.track.log.Logger;

public class PermissionUtil {
    private static final String TAG = "permission";
    private static final int FLAG_INTERNET = 1;
    private static final int FLAG_ACCESS_NETWORK_STATE = 2;
    private static final int FLAG_EXTERNAL_STORAGE = 4;
    private static final int FLAG_READ_PHONE_STATE = 8;
    private static PackageManager sPackageManager;
    private static String sPackageName;
    private static int sPermissionFlags;

    private PermissionUtil() {
    }

    public static boolean hasInternetPermission() {
        return PermissionUtil.checkPermission("android.permission.INTERNET", 1);
    }

    public static boolean hasAccessNetworkStatePermission() {
        return PermissionUtil.checkPermission("android.permission.ACCESS_NETWORK_STATE", 2);
    }

    public static boolean hasWriteExternalPermission() {
        return PermissionUtil.checkPermission("android.permission.WRITE_EXTERNAL_STORAGE", 4);
    }

    public static boolean checkReadPhoneStatePermission() {
        return PermissionUtil.checkPermission("android.permission.READ_PHONE_STATE", 8);
    }

    private static boolean checkPermission(String permissionName, int flag) {
        boolean hasPermission;
        if (sPackageManager == null) {
            Context context = TrackerContext.get().getApplicationContext();
            sPackageManager = context.getPackageManager();
            sPackageName = context.getPackageName();
        }
        if ((sPermissionFlags & flag) != 0) {
            return true;
        }
        try {
            hasPermission = 0 == sPackageManager.checkPermission(permissionName, sPackageName);
        }
        catch (Throwable e) {
            hasPermission = false;
            Logger.d(TAG, e, "checkPermission failed", new Object[0]);
        }
        if (hasPermission) {
            sPermissionFlags |= flag;
            return true;
        }
        return false;
    }

    static {
        sPermissionFlags = 0;
    }
}

