/*
 * Decompiled with CFR 0.152.
 */
package com.growingio.android.sdk.track.utils;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class ObjectUtils {
    private ObjectUtils() {
    }

    public static boolean equals(Object objL, Object objR) {
        return objL == objR || objL != null && objL.equals(objR);
    }

    public static int hashCode(Object o) {
        return o != null ? o.hashCode() : 0;
    }

    public static String toString(Object o) {
        return String.valueOf(o);
    }

    public static String reflectToString(Object o) {
        try {
            StringBuilder objectInfo = new StringBuilder();
            Class<?> clazz = o.getClass();
            objectInfo.append(clazz.getSimpleName()).append(" {\n");
            ObjectUtils.appendFields(objectInfo, o, clazz);
            while (clazz.getSuperclass() != null) {
                clazz = clazz.getSuperclass();
                ObjectUtils.appendFields(objectInfo, o, clazz);
            }
            return objectInfo.append("}\n").toString();
        }
        catch (Throwable throwable) {
            return o.toString();
        }
    }

    private static void appendFields(StringBuilder builder, Object o, Class<?> clazz) throws IllegalAccessException {
        AccessibleObject[] fields = clazz.getDeclaredFields();
        AccessibleObject.setAccessible(fields, true);
        for (AccessibleObject field : fields) {
            String fieldName = ((Field)field).getName();
            if (fieldName.contains("$") || ObjectUtils.customProcess(builder, o, (Field)field)) continue;
            Object fieldValue = ((Field)field).get(o);
            builder.append("\t").append(fieldName).append(": ").append(fieldValue).append("\n");
        }
    }

    private static boolean customProcess(StringBuilder builder, Object o, Field field) {
        try {
            if (field.isAnnotationPresent(FieldToString.class)) {
                for (Annotation annotation : field.getAnnotations()) {
                    if (!(annotation instanceof FieldToString)) continue;
                    FieldToString fieldToStringAnnotation = (FieldToString)annotation;
                    Method fieldToStringMethod = fieldToStringAnnotation.clazz().getMethod(fieldToStringAnnotation.method(), fieldToStringAnnotation.parameterTypes());
                    fieldToStringMethod.setAccessible(true);
                    builder.append("\t").append(field.getName()).append(": ").append(fieldToStringMethod.invoke(o, field.get(o))).append("\n");
                    return true;
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface FieldToString {
        public Class<?> clazz();

        public String method();

        public Class<?>[] parameterTypes() default {};
    }
}

