/*
 * Decompiled with CFR 0.152.
 */
package com.growingio.android.sdk.track.utils;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

public class NetworkUtil {
    private NetworkUtil() {
    }

    @Nullable
    private static NetworkInfo getActiveNetworkInfo(Context context) {
        ConnectivityManager manager = (ConnectivityManager)context.getSystemService("connectivity");
        if (manager != null) {
            return manager.getActiveNetworkInfo();
        }
        return null;
    }

    @NonNull
    public static NetworkState getActiveNetworkState(Context context) {
        NetworkInfo networkInfo = NetworkUtil.getActiveNetworkInfo(context);
        if (networkInfo == null) {
            return new NetworkState(false, false, false, "UNKNOWN");
        }
        return new NetworkState(networkInfo.isConnected(), networkInfo.isConnected() && networkInfo.getType() != 1, networkInfo.isConnected() && networkInfo.getType() == 1, NetworkUtil.getNetworkName(networkInfo));
    }

    public static String getNetworkName(NetworkInfo networkInfo) {
        if (networkInfo != null && networkInfo.isConnected()) {
            return NetworkUtil.getNetworkName(networkInfo.getType(), networkInfo.getSubtype(), networkInfo.getSubtypeName());
        }
        return "UNKNOWN";
    }

    public static String getNetworkName(int type, int subType, String subtypeName) {
        if (type == 1) {
            return "WIFI";
        }
        switch (subType) {
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 11: 
            case 16: {
                return "2G";
            }
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 15: 
            case 17: {
                return "3G";
            }
            case 13: 
            case 18: {
                return "4G";
            }
            case 20: {
                return "5G";
            }
        }
        if ("TD-SCDMA".equalsIgnoreCase(subtypeName) || "WCDMA".equalsIgnoreCase(subtypeName) || "CDMA2000".equalsIgnoreCase(subtypeName)) {
            return "3G";
        }
        return "UNKNOWN";
    }

    public static class NetworkState {
        private final boolean mIsConnected;
        private final boolean mIsMobileData;
        private final boolean mIsWifi;
        private final String mNetworkName;

        private NetworkState(boolean isConnected, boolean isMobileData, boolean isWifi, String networkName) {
            this.mIsConnected = isConnected;
            this.mIsMobileData = isMobileData;
            this.mIsWifi = isWifi;
            this.mNetworkName = networkName;
        }

        public boolean isConnected() {
            return this.mIsConnected;
        }

        public boolean isMobileData() {
            return this.mIsMobileData;
        }

        public boolean isWifi() {
            return this.mIsWifi;
        }

        public String getNetworkName() {
            return this.mNetworkName;
        }
    }
}

