/*
 * Decompiled with CFR 0.152.
 */
package com.growingio.android.sdk.track.utils;

import android.app.Activity;
import android.content.Context;
import android.content.ContextWrapper;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.View;

public final class ActivityUtil {
    private ActivityUtil() {
    }

    @Nullable
    public static Activity findActivity(@Nullable View view) {
        if (view == null) {
            return null;
        }
        return ActivityUtil.findActivity(view.getContext());
    }

    @Nullable
    public static Activity findActivity(@NonNull Context context) {
        if (!(context instanceof ContextWrapper)) {
            return null;
        }
        ContextWrapper current = (ContextWrapper)context;
        while (true) {
            if (current instanceof Activity) {
                return (Activity)current;
            }
            Context parent = current.getBaseContext();
            if (!(parent instanceof ContextWrapper)) break;
            current = (ContextWrapper)parent;
        }
        return null;
    }

    public static boolean isDestroy(Context context) {
        Activity activity = ActivityUtil.findActivity(context);
        if (activity != null && Build.VERSION.SDK_INT >= 17) {
            return activity.isDestroyed();
        }
        return false;
    }
}

