/*
 * Decompiled with CFR 0.152.
 */
package com.growingio.android.sdk.track.providers;

import android.text.TextUtils;
import com.growingio.android.sdk.track.ipc.PersistentDataProvider;
import com.growingio.android.sdk.track.listener.ListenerContainer;
import com.growingio.android.sdk.track.listener.OnUserIdChangedListener;
import com.growingio.android.sdk.track.log.Logger;
import com.growingio.android.sdk.track.providers.ConfigurationProvider;
import com.growingio.android.sdk.track.providers.SessionProvider;
import com.growingio.android.sdk.track.utils.ObjectUtils;

public class UserInfoProvider
extends ListenerContainer<OnUserIdChangedListener, String> {
    private static final String TAG = "UserInfoPolicy";

    private UserInfoProvider() {
    }

    public static UserInfoProvider get() {
        return SingleInstance.INSTANCE;
    }

    public String getLoginUserKey() {
        return PersistentDataProvider.get().getLoginUserKey();
    }

    public String getLoginUserId() {
        return PersistentDataProvider.get().getLoginUserId();
    }

    public void setLoginUserId(String userId) {
        this.setLoginUserId(userId, null);
    }

    public void setLoginUserId(String userId, String userKey) {
        if (!ConfigurationProvider.core().isIdMappingEnabled()) {
            userKey = null;
        }
        if (userKey != null && userKey.length() > 1000) {
            Logger.e(TAG, "GrowingIO.setUserId(KEY, VALUE):KEY\u957f\u5ea6\u5927\u4e8e1000\uff0c\u4e0d\u53d1\u9001", new Object[0]);
            return;
        }
        if (userId != null && userId.length() > 1000) {
            Logger.e(TAG, "GrowingIO.setUserId(KEY, VALUE):VALUE\u957f\u5ea6\u5927\u4e8e1000\uff0c\u4e0d\u53d1\u9001", new Object[0]);
            return;
        }
        if (TextUtils.isEmpty((CharSequence)userId)) {
            PersistentDataProvider.get().setLoginUserIdAndUserKey(null, null);
            Logger.d(TAG, "clean the userId (and will also clean the userKey", new Object[0]);
            this.dispatchActions(null);
            return;
        }
        if (ObjectUtils.equals(userId, this.getLoginUserId())) {
            if (!ObjectUtils.equals(this.getLoginUserKey(), userKey)) {
                PersistentDataProvider.get().setLoginUserIdAndUserKey(userId, userKey);
            }
            Logger.d(TAG, "setUserId, but the userId is same as the old userId, just return", new Object[0]);
            return;
        }
        this.dispatchActions(userId);
        PersistentDataProvider.get().setLoginUserIdAndUserKey(userId, TextUtils.isEmpty((CharSequence)userKey) ? null : userKey);
        this.needSendVisit(userId);
    }

    public void registerUserIdChangedListener(OnUserIdChangedListener l) {
        this.register(l);
    }

    public void unregisterUserIdChangedListener(OnUserIdChangedListener l) {
        this.unregister(l);
    }

    @Override
    protected void singleAction(OnUserIdChangedListener listener, String action) {
        listener.onUserIdChanged(action);
    }

    private void needSendVisit(String newUserId) {
        String mLatestNonNullUserId = PersistentDataProvider.get().getLatestNonNullUserId();
        Logger.d(TAG, "onUserIdChanged: newUserId = " + newUserId + ", mLatestNonNullUserId = " + mLatestNonNullUserId, new Object[0]);
        if (newUserId != null && newUserId.length() != 0) {
            if (TextUtils.isEmpty((CharSequence)mLatestNonNullUserId)) {
                SessionProvider.get().generateVisit();
            } else if (!newUserId.equals(mLatestNonNullUserId)) {
                SessionProvider.get().refreshSessionId();
                SessionProvider.get().generateVisit();
            }
            PersistentDataProvider.get().setLatestNonNullUserId(newUserId);
        }
    }

    private static class SingleInstance {
        private static final UserInfoProvider INSTANCE = new UserInfoProvider();

        private SingleInstance() {
        }
    }
}

