/*
 * Decompiled with CFR 0.152.
 */
package com.growingio.android.sdk.track.providers;

import android.app.Activity;
import com.growingio.android.sdk.track.TrackMainThread;
import com.growingio.android.sdk.track.events.TrackEventGenerator;
import com.growingio.android.sdk.track.ipc.PersistentDataProvider;
import com.growingio.android.sdk.track.listener.IActivityLifecycle;
import com.growingio.android.sdk.track.listener.event.ActivityLifecycleEvent;
import com.growingio.android.sdk.track.log.Logger;
import com.growingio.android.sdk.track.providers.ActivityStateProvider;
import com.growingio.android.sdk.track.providers.ConfigurationProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public class SessionProvider
implements IActivityLifecycle {
    private static final String TAG = "SessionProvider";
    private final List<String> mActivityList = new ArrayList<String>();
    private final long mSessionInterval = (long)ConfigurationProvider.core().getSessionInterval() * 1000L;
    private double mLatitude = 0.0;
    private double mLongitude = 0.0;

    private SessionProvider() {
    }

    public void init() {
        this.mActivityList.clear();
        ActivityStateProvider.get().registerActivityLifecycleListener(this);
    }

    public static SessionProvider get() {
        return SingleInstance.INSTANCE;
    }

    void checkAndSendVisit(long resumeTime) {
        if (resumeTime - PersistentDataProvider.get().getLatestPauseTime() >= this.mSessionInterval) {
            this.refreshSessionId();
            this.generateVisit();
        }
    }

    public void refreshSessionId() {
        PersistentDataProvider.get().setSessionId(UUID.randomUUID().toString());
        PersistentDataProvider.get().setSendVisitAfterRefreshSessionId(false);
    }

    public void generateVisit() {
        if (!ConfigurationProvider.core().isDataCollectionEnabled()) {
            return;
        }
        PersistentDataProvider.get().setSendVisitAfterRefreshSessionId(true);
        TrackEventGenerator.generateVisitEvent();
    }

    public void setLocation(double latitude, double longitude) {
        double eps = 1.0E-5;
        if (Math.abs(latitude) < eps && Math.abs(longitude) < eps) {
            Logger.d(TAG, "found invalid latitude and longitude, and return: ", latitude, ", ", longitude);
            return;
        }
        if (this.mLatitude == 0.0 && Math.abs(latitude) > eps || this.mLongitude == 0.0 && Math.abs(longitude) > eps) {
            this.mLatitude = latitude;
            this.mLongitude = longitude;
            this.generateVisit();
        } else {
            this.mLatitude = latitude;
            this.mLongitude = longitude;
        }
    }

    public void cleanLocation() {
        this.mLatitude = 0.0;
        this.mLongitude = 0.0;
    }

    public double getLatitude() {
        return this.mLatitude;
    }

    public double getLongitude() {
        return this.mLongitude;
    }

    @Override
    public void onActivityLifecycle(ActivityLifecycleEvent event) {
        Activity activity = event.getActivity();
        if (activity == null) {
            return;
        }
        if (event.eventType == ActivityLifecycleEvent.EVENT_TYPE.ON_STARTED) {
            if (PersistentDataProvider.get().getActivityCount() == 0) {
                TrackMainThread.trackMain().postActionToTrackMain(new Runnable(){

                    @Override
                    public void run() {
                        SessionProvider.this.checkAndSendVisit(System.currentTimeMillis());
                    }
                });
            }
            this.mActivityList.add(activity.toString());
            PersistentDataProvider.get().addActivityCount();
        } else if (event.eventType == ActivityLifecycleEvent.EVENT_TYPE.ON_STOPPED && this.mActivityList.contains(activity.toString())) {
            if (this.mActivityList.remove(activity.toString())) {
                PersistentDataProvider.get().delActivityCount();
            }
            if (PersistentDataProvider.get().getActivityCount() == 0) {
                TrackMainThread.trackMain().postActionToTrackMain(new Runnable(){

                    @Override
                    public void run() {
                        PersistentDataProvider.get().setLatestPauseTime(System.currentTimeMillis());
                        TrackEventGenerator.generateAppClosedEvent();
                    }
                });
            }
        }
    }

    private static class SingleInstance {
        private static final SessionProvider INSTANCE = new SessionProvider();

        private SingleInstance() {
        }
    }
}

