/*
 * Decompiled with CFR 0.152.
 */
package com.growingio.android.sdk.track.providers;

import android.annotation.SuppressLint;
import android.content.ContentResolver;
import android.content.Context;
import android.os.Build;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import com.growingio.android.sdk.TrackerContext;
import com.growingio.android.sdk.track.ipc.PersistentDataProvider;
import com.growingio.android.sdk.track.log.Logger;
import com.growingio.android.sdk.track.utils.DeviceUtil;
import com.growingio.android.sdk.track.utils.OaidHelper;
import com.growingio.android.sdk.track.utils.PermissionUtil;
import java.nio.charset.Charset;
import java.util.UUID;

public class DeviceInfoProvider {
    private static final String TAG = "DeviceInfoProvider";
    private static final String DEVICE_TYPE_PHONE = "PHONE";
    private static final String DEVICE_TYPE_PAD = "PAD";
    private static final String MAGIC_ANDROID_ID = "9774d56d682e549c";
    private final Context mContext = TrackerContext.get().getApplicationContext();
    private String mOperatingSystemVersion;
    private String mDeviceBrand;
    private String mDeviceModel;
    private String mDeviceType;
    private int mScreenHeight;
    private int mScreenWidth;
    private String mAndroidId;
    private String mImei;
    private String mOaid;
    private String mGoogleAdId;
    private String mDeviceId;

    private DeviceInfoProvider() {
    }

    public static DeviceInfoProvider get() {
        return SingleInstance.INSTANCE;
    }

    public String getOperatingSystemVersion() {
        if (TextUtils.isEmpty((CharSequence)this.mOperatingSystemVersion)) {
            this.mOperatingSystemVersion = Build.VERSION.RELEASE == null ? "UNKNOWN" : Build.VERSION.RELEASE;
        }
        return this.mOperatingSystemVersion;
    }

    public String getDeviceBrand() {
        if (TextUtils.isEmpty((CharSequence)this.mDeviceBrand)) {
            this.mDeviceBrand = Build.BRAND == null ? "UNKNOWN" : Build.BRAND;
        }
        return this.mDeviceBrand;
    }

    public String getDeviceModel() {
        if (TextUtils.isEmpty((CharSequence)this.mDeviceModel)) {
            this.mDeviceModel = Build.MODEL == null ? "UNKNOWN" : Build.MODEL;
        }
        return this.mDeviceModel;
    }

    public String getDeviceType() {
        if (TextUtils.isEmpty((CharSequence)this.mDeviceType)) {
            this.mDeviceType = DeviceUtil.isPhone(this.mContext) ? DEVICE_TYPE_PHONE : DEVICE_TYPE_PAD;
        }
        return this.mDeviceType;
    }

    public int getScreenHeight() {
        if (this.mScreenHeight <= 0) {
            DisplayMetrics metrics = DeviceUtil.getDisplayMetrics(this.mContext);
            this.mScreenHeight = metrics.heightPixels;
        }
        return this.mScreenHeight;
    }

    public int getScreenWidth() {
        if (this.mScreenWidth <= 0) {
            DisplayMetrics metrics = DeviceUtil.getDisplayMetrics(this.mContext);
            this.mScreenWidth = metrics.widthPixels;
        }
        return this.mScreenWidth;
    }

    @SuppressLint(value={"MissingPermission"})
    public String getImei() {
        if (TextUtils.isEmpty((CharSequence)this.mImei) && PermissionUtil.checkReadPhoneStatePermission()) {
            try {
                TelephonyManager tm = (TelephonyManager)this.mContext.getSystemService("phone");
                this.mImei = Build.VERSION.SDK_INT >= 26 ? tm.getImei() : tm.getDeviceId();
            }
            catch (Throwable e) {
                Logger.d(TAG, "don't have permission android.permission.READ_PHONE_STATE,initIMEI failed ", new Object[0]);
            }
        }
        return null;
    }

    public String getAndroidId() {
        if (TextUtils.isEmpty((CharSequence)this.mAndroidId)) {
            this.mAndroidId = Settings.System.getString((ContentResolver)this.mContext.getContentResolver(), (String)"android_id");
        }
        return this.mAndroidId;
    }

    public String getOaid() {
        if (TextUtils.isEmpty((CharSequence)this.mOaid)) {
            this.mOaid = TrackerContext.get().executeData(null, OaidHelper.class, String.class);
        }
        return this.mOaid;
    }

    public String getGoogleAdId() {
        return this.mGoogleAdId;
    }

    public String getDeviceId() {
        if (TextUtils.isEmpty((CharSequence)this.mDeviceId)) {
            this.mDeviceId = PersistentDataProvider.get().getDeviceId();
            if (TextUtils.isEmpty((CharSequence)this.mDeviceId)) {
                this.mDeviceId = this.calculateDeviceId();
            }
        }
        return this.mDeviceId;
    }

    private String calculateDeviceId() {
        Logger.d(TAG, "first time calculate deviceId", new Object[0]);
        String adId = this.getAndroidId();
        String result = null;
        if (!TextUtils.isEmpty((CharSequence)adId) && !MAGIC_ANDROID_ID.equals(adId)) {
            result = UUID.nameUUIDFromBytes(adId.getBytes(Charset.forName("UTF-8"))).toString();
        } else {
            String imi = this.getImei();
            if (!TextUtils.isEmpty((CharSequence)imi)) {
                result = UUID.nameUUIDFromBytes(imi.getBytes(Charset.forName("UTF-8"))).toString();
            }
        }
        if (TextUtils.isEmpty(result)) {
            result = UUID.randomUUID().toString();
        }
        if (result != null && result.length() != 0) {
            PersistentDataProvider.get().setDeviceId(result);
        }
        return result;
    }

    private static class SingleInstance {
        private static final DeviceInfoProvider INSTANCE = new DeviceInfoProvider();

        private SingleInstance() {
        }
    }
}

