/*
 * Decompiled with CFR 0.152.
 */
package com.growingio.android.sdk.track.providers;

import android.content.Intent;
import android.net.Uri;
import android.text.TextUtils;
import com.growingio.android.sdk.TrackerContext;
import com.growingio.android.sdk.track.TrackMainThread;
import com.growingio.android.sdk.track.listener.IActivityLifecycle;
import com.growingio.android.sdk.track.listener.event.ActivityLifecycleEvent;
import com.growingio.android.sdk.track.log.DebugLogger;
import com.growingio.android.sdk.track.log.Logger;
import com.growingio.android.sdk.track.modelloader.LoadDataFetcher;
import com.growingio.android.sdk.track.providers.ActivityStateProvider;
import com.growingio.android.sdk.track.providers.ConfigurationProvider;
import com.growingio.android.sdk.track.webservices.Circler;
import com.growingio.android.sdk.track.webservices.Debugger;
import com.growingio.android.sdk.track.webservices.DeepLink;
import com.growingio.android.sdk.track.webservices.WebService;
import java.util.HashMap;

public class DeepLinkProvider
implements IActivityLifecycle {
    private static final String TAG = "DeepLinkProvider";
    private static final String WEB_SERVICES_HOST = "growingio";
    private static final String WEB_SERVICES_PATH = "/webservice";
    private static final String WEB_SERVICES_TYPE = "serviceType";
    public static final String SERVICE_DEBUGGER_TYPE = "debugger";
    public static final String SERVICE_CIRCLE_TYPE = "circle";

    private DeepLinkProvider() {
    }

    public void init() {
        ActivityStateProvider.get().registerActivityLifecycleListener(this);
    }

    public static DeepLinkProvider get() {
        return SingleInstance.INSTANCE;
    }

    @Override
    public void onActivityLifecycle(ActivityLifecycleEvent event) {
        if (event.eventType == ActivityLifecycleEvent.EVENT_TYPE.ON_CREATED || event.eventType == ActivityLifecycleEvent.EVENT_TYPE.ON_NEW_INTENT) {
            Intent intent = event.getIntent();
            if (intent == null) {
                return;
            }
            Uri data = intent.getData();
            if (data == null) {
                return;
            }
            String urlScheme = ConfigurationProvider.core().getUrlScheme();
            if (urlScheme.equals(data.getScheme())) {
                Logger.d(TAG, "enter growingio:" + data.toString(), new Object[0]);
                TrackMainThread.trackMain().postActionToTrackMain(() -> this.dispatchUri(data));
            }
        }
    }

    void dispatchUri(Uri data) {
        if (WEB_SERVICES_HOST.equals(data.getHost()) && WEB_SERVICES_PATH.equals(data.getPath())) {
            String openConsole;
            String serviceType = data.getQueryParameter(WEB_SERVICES_TYPE);
            if (!TextUtils.isEmpty((CharSequence)serviceType)) {
                Logger.d(TAG, "Start web service " + serviceType, new Object[0]);
                HashMap<String, String> params = new HashMap<String, String>();
                for (String parameterName : data.getQueryParameterNames()) {
                    params.put(parameterName, data.getQueryParameter(parameterName));
                }
                if (serviceType.equals(SERVICE_DEBUGGER_TYPE)) {
                    TrackerContext.get().loadData(new Debugger(params), Debugger.class, WebService.class, new LoadDataFetcher.DataCallback<WebService>(){

                        @Override
                        public void onDataReady(WebService data) {
                            Logger.d(DeepLinkProvider.TAG, "start debugger success", new Object[0]);
                        }

                        @Override
                        public void onLoadFailed(Exception e) {
                            Logger.e(DeepLinkProvider.TAG, e.getMessage(), new Object[0]);
                        }
                    });
                } else if (serviceType.equals(SERVICE_CIRCLE_TYPE)) {
                    TrackerContext.get().loadData(new Circler(params), Circler.class, WebService.class, new LoadDataFetcher.DataCallback<WebService>(){

                        @Override
                        public void onDataReady(WebService data) {
                            Logger.d(DeepLinkProvider.TAG, "start circle choose success", new Object[0]);
                        }

                        @Override
                        public void onLoadFailed(Exception e) {
                            Logger.e(DeepLinkProvider.TAG, e.getMessage(), new Object[0]);
                        }
                    });
                }
            }
            if (!TextUtils.isEmpty((CharSequence)(openConsole = data.getQueryParameter("openConsoleLog"))) && "YES".equalsIgnoreCase(openConsole)) {
                Logger.addLogger(new DebugLogger());
            }
        } else {
            HashMap<String, String> params = new HashMap<String, String>();
            for (String parameterName : data.getQueryParameterNames()) {
                params.put(parameterName, data.getQueryParameter(parameterName));
            }
            TrackerContext.get().loadData(new DeepLink(params), DeepLink.class, WebService.class, new LoadDataFetcher.DataCallback<WebService>(){

                @Override
                public void onDataReady(WebService data) {
                    Logger.d(DeepLinkProvider.TAG, "open deep link.", new Object[0]);
                }

                @Override
                public void onLoadFailed(Exception e) {
                    Logger.e(DeepLinkProvider.TAG, e.getMessage(), new Object[0]);
                }
            });
        }
    }

    private static class SingleInstance {
        private static final DeepLinkProvider INSTANCE = new DeepLinkProvider();

        private SingleInstance() {
        }
    }
}

