/*
 * Decompiled with CFR 0.152.
 */
package com.growingio.android.sdk.track.providers;

import android.text.TextUtils;
import com.growingio.android.sdk.Configurable;
import com.growingio.android.sdk.CoreConfiguration;
import com.growingio.android.sdk.track.log.DebugLogger;
import com.growingio.android.sdk.track.log.Logger;
import com.growingio.android.sdk.track.utils.ObjectUtils;
import com.growingio.android.sdk.track.utils.ThreadUtils;
import java.util.HashMap;
import java.util.Map;

public class ConfigurationProvider {
    private static final String TAG = "ConfigurationProvider";
    private final CoreConfiguration mCoreConfiguration;
    private final Map<Class<? extends Configurable>, Configurable> sModuleConfigs = new HashMap<Class<? extends Configurable>, Configurable>();
    private static ConfigurationProvider INSTANCE = null;

    private ConfigurationProvider(CoreConfiguration coreConfiguration, Map<Class<? extends Configurable>, Configurable> moduleConfigs) {
        if (TextUtils.isEmpty((CharSequence)coreConfiguration.getProjectId())) {
            throw new IllegalStateException("ProjectId is NULL");
        }
        if (TextUtils.isEmpty((CharSequence)coreConfiguration.getUrlScheme())) {
            throw new IllegalStateException("UrlScheme is NULL");
        }
        if (coreConfiguration.getProjectId().equals("UNKNOWN") || coreConfiguration.getUrlScheme().equals("UNKNOWN")) {
            Logger.e(TAG, "Growing Sdk \u914d\u7f6e\u52a0\u8f7d\u5931\u8d25\uff0c\u8bf7\u91cd\u65b0\u521d\u59cb\u5316", new Object[0]);
            this.mCoreConfiguration = coreConfiguration;
            return;
        }
        if (!ThreadUtils.runningOnUiThread()) {
            throw new IllegalStateException("Growing Sdk \u521d\u59cb\u5316\u5fc5\u987b\u5728\u4e3b\u7ebf\u7a0b\u4e2d\u8c03\u7528\u3002");
        }
        this.mCoreConfiguration = coreConfiguration;
        this.sModuleConfigs.clear();
        if (moduleConfigs != null) {
            this.sModuleConfigs.putAll(moduleConfigs);
        }
        if (coreConfiguration.isDebugEnabled()) {
            Logger.addLogger(new DebugLogger());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ConfigurationProvider get() {
        if (INSTANCE == null) {
            Logger.e(TAG, "GrowingSDK doesn't have config yet, please initialized before use API", new Object[0]);
            return ConfigurationProvider.empty();
        }
        Class<ConfigurationProvider> clazz = ConfigurationProvider.class;
        synchronized (ConfigurationProvider.class) {
            if (INSTANCE != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return INSTANCE;
            }
            Logger.e(TAG, "GrowingSDK doesn't have config yet, please initialized before use API", new Object[0]);
            // ** MonitorExit[var0] (shouldn't be in output)
            return ConfigurationProvider.empty();
        }
    }

    public static void initWithConfig(CoreConfiguration coreConfiguration, Map<Class<? extends Configurable>, Configurable> moduleConfigs) {
        Logger.w(TAG, "Warning!! GrowingSDK already has the config, please don't initialized again!", new Object[0]);
        INSTANCE = new ConfigurationProvider(coreConfiguration, moduleConfigs);
    }

    private static ConfigurationProvider empty() {
        return new ConfigurationProvider(new CoreConfiguration("UNKNOWN", "UNKNOWN"), null);
    }

    void addConfiguration(Configurable config) {
        if (config != null) {
            this.sModuleConfigs.put(config.getClass(), config);
        }
    }

    public String getAllConfigurationInfo() {
        StringBuilder info = new StringBuilder();
        if (!ConfigurationProvider.core().isDebugEnabled()) {
            return "GrowingSDK display config info only in debug environment.";
        }
        info.append(ObjectUtils.reflectToString(ConfigurationProvider.core()));
        for (Configurable configurable : this.sModuleConfigs.values()) {
            info.append(ObjectUtils.reflectToString(configurable));
        }
        return info.toString();
    }

    public <T> T getConfiguration(Class<? extends Configurable> clazz) {
        return (T)this.sModuleConfigs.get(clazz);
    }

    public static CoreConfiguration core() {
        return ConfigurationProvider.get().mCoreConfiguration;
    }
}

