/*
 * Decompiled with CFR 0.152.
 */
package com.growingio.android.sdk.track.providers;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.text.TextUtils;
import com.growingio.android.sdk.TrackerContext;
import com.growingio.android.sdk.track.log.Logger;
import com.growingio.android.sdk.track.providers.ConfigurationProvider;

public class AppInfoProvider {
    private static final String TAG = "AppInfoProvider";
    private final Context mContext = TrackerContext.get().getApplicationContext();
    private String mPackageName;
    private String mAppName;
    private String mAppVersion;
    private String mAppChannel;

    private AppInfoProvider() {
    }

    public static AppInfoProvider get() {
        return SingleInstance.INSTANCE;
    }

    public String getPackageName() {
        if (TextUtils.isEmpty((CharSequence)this.mPackageName)) {
            this.mPackageName = this.mContext.getPackageName();
        }
        return this.mPackageName;
    }

    public String getAppName() {
        if (TextUtils.isEmpty((CharSequence)this.mAppName)) {
            try {
                PackageManager packageManager = this.mContext.getPackageManager();
                this.mAppName = packageManager.getApplicationLabel(this.mContext.getApplicationInfo()).toString();
            }
            catch (Exception e) {
                Logger.e(TAG, e);
            }
        }
        return this.mAppName;
    }

    public String getAppVersion() {
        if (TextUtils.isEmpty((CharSequence)this.mAppVersion)) {
            PackageManager packageManager = this.mContext.getPackageManager();
            try {
                PackageInfo info = packageManager.getPackageInfo(this.mContext.getPackageName(), 0);
                this.mAppVersion = info.versionName;
            }
            catch (PackageManager.NameNotFoundException e) {
                Logger.e(TAG, e);
            }
        }
        return this.mAppVersion;
    }

    public String getAppChannel() {
        if (TextUtils.isEmpty((CharSequence)this.mAppChannel)) {
            this.mAppChannel = ConfigurationProvider.core().getChannel();
        }
        return this.mAppChannel;
    }

    private static class SingleInstance {
        private static final AppInfoProvider INSTANCE = new AppInfoProvider();

        private SingleInstance() {
        }
    }
}

