/*
 * Decompiled with CFR 0.152.
 */
package com.growingio.android.sdk.track.providers;

import android.app.Activity;
import android.app.Application;
import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.growingio.android.sdk.track.listener.IActivityLifecycle;
import com.growingio.android.sdk.track.listener.ListenerContainer;
import com.growingio.android.sdk.track.listener.event.ActivityLifecycleEvent;
import com.growingio.android.sdk.track.utils.SysTrace;
import java.lang.ref.WeakReference;

public class ActivityStateProvider
extends ListenerContainer<IActivityLifecycle, ActivityLifecycleEvent>
implements Application.ActivityLifecycleCallbacks {
    private WeakReference<Activity> mResumeActivity = new WeakReference<Object>(null);
    private WeakReference<Activity> mForegroundActivity = new WeakReference<Object>(null);
    private int mCurrentRootWindowsHashCode = -1;

    private ActivityStateProvider() {
    }

    public static ActivityStateProvider get() {
        return SingleInstance.INSTANCE;
    }

    private void dispatchActivityLifecycle(ActivityLifecycleEvent event) {
        Activity activity = event.getActivity();
        if (event.eventType == ActivityLifecycleEvent.EVENT_TYPE.ON_RESUMED) {
            this.setResumeActivity(activity);
        } else if (event.eventType == ActivityLifecycleEvent.EVENT_TYPE.ON_PAUSED) {
            this.setResumeActivity(null);
        } else if (event.eventType == ActivityLifecycleEvent.EVENT_TYPE.ON_CREATED) {
            this.setForegroundActivity(activity);
        } else if (event.eventType != ActivityLifecycleEvent.EVENT_TYPE.ON_STOPPED && event.eventType == ActivityLifecycleEvent.EVENT_TYPE.ON_DESTROYED) {
            if (activity == this.getResumedActivity()) {
                this.setResumeActivity(null);
            }
            if (activity == this.getForegroundActivity()) {
                this.setForegroundActivity(null);
            }
        }
        this.dispatchActions(event);
    }

    private synchronized void setResumeActivity(Activity activity) {
        this.mResumeActivity = new WeakReference<Activity>(activity);
        if (activity != null) {
            this.setForegroundActivity(activity);
        }
    }

    public synchronized Activity getResumedActivity() {
        return (Activity)this.mResumeActivity.get();
    }

    public synchronized Activity getForegroundActivity() {
        return (Activity)this.mForegroundActivity.get();
    }

    private synchronized void setForegroundActivity(Activity activity) {
        this.mForegroundActivity = new WeakReference<Activity>(activity);
    }

    public int getCurrentRootWindowsHashCode() {
        if (this.mCurrentRootWindowsHashCode == -1 && this.mForegroundActivity != null && this.mForegroundActivity.get() != null) {
            this.mCurrentRootWindowsHashCode = ((Activity)this.mForegroundActivity.get()).getWindow().getDecorView().hashCode();
        }
        return this.mCurrentRootWindowsHashCode;
    }

    public void registerActivityLifecycleListener(IActivityLifecycle lifecycle) {
        this.register(lifecycle);
    }

    public void unregisterActivityLifecycleListener(IActivityLifecycle lifecycle) {
        this.unregister(lifecycle);
    }

    public void onActivityCreated(@NonNull Activity activity, @Nullable Bundle savedInstanceState) {
        SysTrace.beginSection("gio.ActivityOnCreate");
        this.dispatchActivityLifecycle(ActivityLifecycleEvent.createOnCreatedEvent(activity, savedInstanceState));
        SysTrace.endSection();
    }

    public void onActivityStarted(@NonNull Activity activity) {
        SysTrace.beginSection("gio.onActivityStart");
        this.dispatchActivityLifecycle(ActivityLifecycleEvent.createOnStartedEvent(activity));
        SysTrace.endSection();
    }

    public void onActivityResumed(@NonNull Activity activity) {
        SysTrace.beginSection("gio.onActivityResumed");
        this.dispatchActivityLifecycle(ActivityLifecycleEvent.createOnResumedEvent(activity));
        SysTrace.endSection();
    }

    public void onActivityPaused(@NonNull Activity activity) {
        SysTrace.beginSection("gio.onActivityPaused");
        this.dispatchActivityLifecycle(ActivityLifecycleEvent.createOnPausedEvent(activity));
        SysTrace.endSection();
    }

    public void onActivityStopped(@NonNull Activity activity) {
        this.dispatchActivityLifecycle(ActivityLifecycleEvent.createOnStoppedEvent(activity));
    }

    public void onActivitySaveInstanceState(@NonNull Activity activity, @NonNull Bundle outState) {
        this.dispatchActivityLifecycle(ActivityLifecycleEvent.createOnSaveInstanceStateEvent(activity, outState));
    }

    public void onActivityDestroyed(@NonNull Activity activity) {
        this.dispatchActivityLifecycle(ActivityLifecycleEvent.createOnDestroyedEvent(activity));
    }

    public void onActivityNewIntent(@NonNull Activity activity, Intent intent) {
        this.dispatchActivityLifecycle(ActivityLifecycleEvent.createOnNewIntentEvent(activity, intent));
    }

    @Override
    protected void singleAction(IActivityLifecycle listener, ActivityLifecycleEvent action) {
        listener.onActivityLifecycle(action);
    }

    private static class SingleInstance {
        private static final ActivityStateProvider INSTANCE = new ActivityStateProvider();

        private SingleInstance() {
        }
    }
}

