/*
 * Decompiled with CFR 0.152.
 */
package com.growingio.android.sdk.track.modelloader;

import com.growingio.android.sdk.track.modelloader.ModelLoader;
import com.growingio.android.sdk.track.modelloader.ModelLoaderFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

class ModelLoaderRegistry {
    private final Map<Class<?>, ModelLoader<?, ?>> cachedModelLoaders = new HashMap();
    private final List<Entry<?, ?>> entries = new ArrayList();

    ModelLoaderRegistry() {
    }

    public synchronized <Model, Data> void put(Class<Model> modelClass, Class<Data> dataClass, ModelLoaderFactory<? extends Model, ? extends Data> factory) {
        this.add(modelClass, dataClass, factory);
        this.cachedModelLoaders.clear();
    }

    public synchronized <Model> ModelLoader<Model, ?> getModelLoaderForClass(Class<Model> modelClass) {
        ModelLoader<?, ?> loader = this.cachedModelLoaders.get(modelClass);
        if (loader == null) {
            loader = this.build(modelClass);
        }
        if (loader == null) {
            return null;
        }
        this.cachedModelLoaders.put(modelClass, loader);
        return loader;
    }

    public synchronized <Model, Data> ModelLoader<Model, Data> getModelLoader(Class<Model> modelClass, Class<Data> dataClass) {
        ModelLoader<?, ?> loader = this.cachedModelLoaders.get(modelClass);
        if (loader == null) {
            loader = this.build(modelClass);
        }
        if (loader == null) {
            return null;
        }
        this.cachedModelLoaders.put(modelClass, loader);
        return loader;
    }

    private <Model, Data> void add(Class<Model> modelClass, Class<Data> dataClass, ModelLoaderFactory<? extends Model, ? extends Data> factory) {
        Iterator<Entry<?, ?>> iterator = this.entries.iterator();
        while (iterator.hasNext()) {
            Entry<Model, Model> entry = iterator.next();
            if (!entry.handles(modelClass, dataClass)) continue;
            iterator.remove();
        }
        Entry<? extends Model, ? extends Data> entry = new Entry<Model, Data>(modelClass, dataClass, factory);
        this.entries.add(entry);
    }

    private synchronized <Model> ModelLoader<?, ?> build(Class<Model> modelClass) {
        for (Entry<Model, Model> entry : this.entries) {
            if (!entry.handles(modelClass)) continue;
            return entry.factory.build();
        }
        return null;
    }

    private static class Entry<Model, Data> {
        private final Class<Model> modelClass;
        final Class<Data> dataClass;
        final ModelLoaderFactory<? extends Model, ? extends Data> factory;

        Entry(Class<Model> modelClass, Class<Data> dataClass, ModelLoaderFactory<? extends Model, ? extends Data> factory) {
            this.modelClass = modelClass;
            this.dataClass = dataClass;
            this.factory = factory;
        }

        public boolean handles(Class<?> modelClass, Class<?> dataClass) {
            return this.handles(modelClass) && this.dataClass.isAssignableFrom(dataClass);
        }

        public boolean handles(Class<?> modelClass) {
            return this.modelClass.isAssignableFrom(modelClass);
        }
    }
}

