/*
 * Decompiled with CFR 0.152.
 */
package com.growingio.android.sdk.track.middleware;

import com.growingio.android.sdk.track.log.Logger;
import com.growingio.android.sdk.track.middleware.GEvent;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public final class Serializer {
    private Serializer() {
    }

    public static byte[] objectSerialize(Serializable object) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        objectOutputStream.writeObject(object);
        return byteArrayOutputStream.toByteArray();
    }

    public static <T> T objectDeserialization(byte[] data) throws IOException, ClassNotFoundException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(data);
        ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
        return (T)objectInputStream.readObject();
    }

    public static GEvent unpack(byte[] data) {
        try {
            return (GEvent)Serializer.objectDeserialization(data);
        }
        catch (IOException e) {
            Logger.e("Serializer", e, e.getMessage(), new Object[0]);
        }
        catch (ClassNotFoundException e) {
            Logger.e("Serializer", e, e.getMessage(), new Object[0]);
        }
        return null;
    }
}

