/*
 * Decompiled with CFR 0.152.
 */
package com.growingio.android.sdk.track.middleware;

import android.annotation.SuppressLint;
import android.app.ActivityManager;
import android.content.Context;
import android.content.SharedPreferences;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import androidx.annotation.NonNull;
import com.growingio.android.sdk.TrackerContext;
import com.growingio.android.sdk.track.ipc.ProcessLock;
import com.growingio.android.sdk.track.log.Logger;
import com.growingio.android.sdk.track.middleware.EventDatabase;
import com.growingio.android.sdk.track.middleware.EventDbResult;
import com.growingio.android.sdk.track.middleware.GEvent;
import com.growingio.android.sdk.track.middleware.IEventNetSender;
import com.growingio.android.sdk.track.middleware.SendResponse;
import com.growingio.android.sdk.track.modelloader.ModelLoader;
import com.growingio.android.sdk.track.utils.NetworkUtil;
import java.text.SimpleDateFormat;
import java.util.Date;

public class EventSender {
    private static final String TAG = "EventSender";
    private static final int EVENTS_BULK_SIZE = 100;
    private final Context mContext;
    private IEventNetSender mEventNetSender;
    private final SharedPreferences mSharedPreferences;
    private final SendHandler mSendHandler;
    private final ProcessLock mProcessLock;
    private final long mDataUploadInterval;
    private final long mCellularDataLimit;
    private int mCacheEventNum = 0;

    public EventSender(Context context, IEventNetSender sender, long dataUploadInterval, long cellularDataLimit) {
        this.mContext = context;
        this.mCellularDataLimit = cellularDataLimit * 1024L * 1024L;
        this.mDataUploadInterval = dataUploadInterval * 1000L;
        this.mEventNetSender = sender;
        this.mProcessLock = new ProcessLock(context, EventSender.class.getName());
        this.mSharedPreferences = context.getSharedPreferences("growing3_sender", 0);
        HandlerThread thread = new HandlerThread(EventSender.class.getName());
        thread.start();
        this.mSendHandler = new SendHandler(thread.getLooper());
    }

    private ModelLoader<EventDatabase, EventDbResult> getDatabaseModelLoader() {
        return TrackerContext.get().getRegistry().getModelLoader(EventDatabase.class, EventDbResult.class);
    }

    private EventDbResult databaseOperation(EventDatabase eventDatabase) {
        ModelLoader<EventDatabase, EventDbResult> modelLoader = this.getDatabaseModelLoader();
        if (modelLoader == null) {
            Logger.e(TAG, "please register database component first", new Object[0]);
            return new EventDbResult(false);
        }
        ModelLoader.LoadData<EventDbResult> loadData = modelLoader.buildLoadData(eventDatabase);
        return (EventDbResult)loadData.fetcher.executeData();
    }

    public void setEventNetSender(IEventNetSender mEventNetSender) {
        this.mEventNetSender = mEventNetSender;
    }

    public void cacheEvent(GEvent event) {
        this.databaseOperation(EventDatabase.insert(event));
    }

    public void sendEvent(GEvent event) {
        this.databaseOperation(EventDatabase.insert(event));
        if (event.getSendPolicy() == 1) {
            this.mSendHandler.uploadInstantEvents();
        } else if (this.mDataUploadInterval > 0L) {
            ++this.mCacheEventNum;
            if (this.mCacheEventNum >= 100) {
                Logger.d(TAG, "cacheEventNum >= EVENTS_BULK_SIZE, toggle one send action", new Object[0]);
                this.mSendHandler.uploadUninstantEvents();
                this.mCacheEventNum = 0;
            }
        } else {
            this.mSendHandler.uploadUninstantEvents();
        }
    }

    void removeAllEvents() {
        Logger.d(TAG, "action: removeAllEvents", new Object[0]);
        this.databaseOperation(EventDatabase.clear());
    }

    private long todayBytes(long delta) {
        long usedBytes;
        String dateKey = "today";
        String usedBytesKey = "today_bytes";
        String todayStr = this.mSharedPreferences.getString(dateKey, "");
        SimpleDateFormat dayFormat = new SimpleDateFormat("yyyyMMdd");
        String realDayTime = dayFormat.format(new Date());
        if (!realDayTime.equals(todayStr)) {
            SharedPreferences.Editor editor = this.mSharedPreferences.edit();
            editor.putString(dateKey, realDayTime);
            editor.putLong(usedBytesKey, 0L);
            editor.apply();
            usedBytes = 0L;
        } else {
            usedBytes = this.mSharedPreferences.getLong(usedBytesKey, 0L);
        }
        if (delta > 0L) {
            this.mSharedPreferences.edit().putLong(usedBytesKey, usedBytes += delta).apply();
        }
        return usedBytes;
    }

    public void removeOverdueEvents() {
        try {
            this.databaseOperation(EventDatabase.outDated());
        }
        catch (Exception e) {
            Logger.d(TAG, "action: removeOverdueEvents,failed", new Object[0]);
        }
    }

    @SuppressLint(value={"WrongConstant"})
    private ActivityManager.MemoryInfo getMemoryInfo() {
        ActivityManager activityManager = (ActivityManager)this.mContext.getSystemService("activity");
        ActivityManager.MemoryInfo memoryInfo = new ActivityManager.MemoryInfo();
        activityManager.getMemoryInfo(memoryInfo);
        return memoryInfo;
    }

    private int numOfMaxEventsPerRequest() {
        ActivityManager.MemoryInfo info = this.getMemoryInfo();
        if (info.lowMemory) {
            return 3;
        }
        return 50;
    }

    void sendEvents(boolean onlyInstant) {
        if (!this.mProcessLock.isAcquired()) {
            Logger.e(TAG, "sendEvents: this process can not get lock", new Object[0]);
            return;
        }
        NetworkUtil.NetworkState networkState = NetworkUtil.getActiveNetworkState(this.mContext);
        if (!networkState.isConnected()) {
            return;
        }
        int[] uploadEvents = onlyInstant ? new int[]{1} : (networkState.isWifi() ? new int[]{1, 2, 3} : new int[]{1, 2});
        block0: for (int policy : uploadEvents) {
            boolean succeeded;
            do {
                if (policy != 1 && networkState.isMobileData() && this.mCellularDataLimit < this.todayBytes(0L)) {
                    Logger.e(TAG, "Today's mobile data is exhausted", new Object[0]);
                    continue block0;
                }
                EventDbResult dbResult = this.databaseOperation(EventDatabase.query(policy, this.numOfMaxEventsPerRequest()));
                if (!dbResult.isSuccess() || dbResult.getSum() <= 0) continue block0;
                SendResponse sendResponse = this.mEventNetSender.send(dbResult.getData(), dbResult.getMediaType());
                succeeded = sendResponse.isSucceeded();
                if (!succeeded) continue;
                String eventType = dbResult.getEventType();
                this.databaseOperation(EventDatabase.delete(dbResult.getLastId(), policy, eventType));
                if (!networkState.isMobileData()) continue;
                this.todayBytes(sendResponse.getUsedBytes());
            } while (succeeded);
        }
    }

    public EventDbResult getGEventsFromPolicy(int policy) {
        return this.databaseOperation(EventDatabase.queryAndDelete(policy, this.numOfMaxEventsPerRequest()));
    }

    private final class SendHandler
    extends Handler {
        private static final int MSG_SEND_INSTANT_EVENTS = 1;
        private static final int MSG_SEND_UNINSTANT_EVENTS = 2;

        private SendHandler(Looper looper) {
            super(looper);
            if (EventSender.this.mDataUploadInterval > 0L) {
                this.sendEmptyMessageDelayed(2, EventSender.this.mDataUploadInterval);
            }
        }

        private void uploadInstantEvents() {
            this.removeMessages(1);
            this.sendEmptyMessage(1);
        }

        private void uploadUninstantEvents() {
            this.removeMessages(2);
            this.sendEmptyMessage(2);
        }

        public void handleMessage(@NonNull Message msg) {
            switch (msg.what) {
                case 1: {
                    EventSender.this.sendEvents(true);
                    break;
                }
                case 2: {
                    this.removeMessages(2);
                    EventSender.this.sendEvents(false);
                    if (EventSender.this.mDataUploadInterval <= 0L) break;
                    this.sendEmptyMessageDelayed(2, EventSender.this.mDataUploadInterval);
                    break;
                }
                default: {
                    Logger.e(EventSender.TAG, "Unexpected value: " + msg.what, new Object[0]);
                }
            }
        }
    }
}

