/*
 * Decompiled with CFR 0.152.
 */
package com.growingio.android.sdk.track.middleware;

import android.os.Build;
import android.text.TextUtils;
import com.growingio.android.sdk.CoreConfiguration;
import com.growingio.android.sdk.TrackerContext;
import com.growingio.android.sdk.track.events.base.BaseEvent;
import com.growingio.android.sdk.track.http.EventEncoder;
import com.growingio.android.sdk.track.http.EventResponse;
import com.growingio.android.sdk.track.http.EventUrl;
import com.growingio.android.sdk.track.log.Logger;
import com.growingio.android.sdk.track.middleware.GEvent;
import com.growingio.android.sdk.track.middleware.IEventNetSender;
import com.growingio.android.sdk.track.middleware.SendResponse;
import com.growingio.android.sdk.track.modelloader.ModelLoader;
import com.growingio.android.sdk.track.providers.ConfigurationProvider;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public class EventHttpSender
implements IEventNetSender {
    private static final String TAG = "EventHttpSender";
    private final String mProjectId;
    private final String mServerHost;

    public EventHttpSender() {
        CoreConfiguration configuration = ConfigurationProvider.core();
        this.mProjectId = configuration.getProjectId();
        this.mServerHost = configuration.getDataCollectionServerHost();
    }

    private ModelLoader<EventUrl, EventResponse> getNetworkModelLoader() {
        return TrackerContext.get().getRegistry().getModelLoader(EventUrl.class, EventResponse.class);
    }

    @Override
    public SendResponse send(byte[] events, String mediaType) {
        boolean successful;
        EventEncoder encoder;
        if (events == null || events.length == 0) {
            return new SendResponse(false, 0L);
        }
        if (this.getNetworkModelLoader() == null) {
            Logger.e(TAG, "please register http request component first", new Object[0]);
            return new SendResponse(false, 0L);
        }
        long time = System.currentTimeMillis();
        EventUrl eventUrl = new EventUrl(this.mServerHost, time).addPath("v3").addPath("projects").addPath(this.mProjectId).addPath("collect").addParam("stm", String.valueOf(time)).setBodyData(events);
        if (!TextUtils.isEmpty((CharSequence)mediaType)) {
            eventUrl.setMediaType(mediaType);
        }
        if ((encoder = TrackerContext.get().executeData(new EventEncoder(eventUrl), EventEncoder.class, EventEncoder.class)) != null) {
            eventUrl = encoder.getEventUrl();
        }
        byte[] data = eventUrl.getRequestBody();
        ModelLoader.LoadData<EventResponse> loadData = this.getNetworkModelLoader().buildLoadData(eventUrl);
        if (!loadData.fetcher.getDataClass().isAssignableFrom(EventResponse.class)) {
            Logger.e(TAG, new IllegalArgumentException("illegal data class for http response."));
            return new SendResponse(false, 0L);
        }
        EventResponse response = (EventResponse)loadData.fetcher.executeData();
        boolean bl = successful = response != null && response.isSucceeded();
        if (successful) {
            Logger.d(TAG, "Send events successfully", new Object[0]);
        } else {
            Logger.d(TAG, "Send events failed, response = " + response, new Object[0]);
        }
        long totalUsed = data == null ? 0L : (long)data.length;
        return new SendResponse(successful, totalUsed);
    }

    public byte[] defaultDataTransfer(List<GEvent> events) {
        if (events == null || events.isEmpty()) {
            return null;
        }
        JSONArray jsonArray = new JSONArray();
        for (GEvent event : events) {
            if (!(event instanceof BaseEvent)) continue;
            JSONObject eventJson = ((BaseEvent)event).toJSONObject();
            jsonArray.put((Object)eventJson);
        }
        if (Build.VERSION.SDK_INT >= 19) {
            return jsonArray.toString().getBytes(StandardCharsets.UTF_8);
        }
        return jsonArray.toString().getBytes();
    }
}

