/*
 * Decompiled with CFR 0.152.
 */
package com.growingio.android.sdk.track.middleware;

import com.growingio.android.sdk.track.middleware.GEvent;
import java.util.ArrayList;
import java.util.List;

public class EventDatabase {
    public static final int DATABASE_OP_INSERT = 0;
    public static final int DATABASE_OP_QUERY = 1;
    public static final int DATABASE_OP_UPDATE = 2;
    public static final int DATABASE_OP_DELETE = 3;
    public static final int DATABASE_OP_OUTDATED = 4;
    public static final int DATABASE_OP_QUERY_DELETE = 5;
    public static final int DATABASE_OP_CLEAR = 6;
    private int dbOp;
    private List<GEvent> events;
    private int policy;
    private int limit;
    private long lastId;
    private String eventType;

    public int getDbOp() {
        return this.dbOp;
    }

    public List<GEvent> getEvents() {
        return this.events;
    }

    public int getPolicy() {
        return this.policy;
    }

    public int getLimit() {
        return this.limit;
    }

    public long getLastId() {
        return this.lastId;
    }

    public String getEventType() {
        return this.eventType;
    }

    public static EventDatabase insert(GEvent event) {
        EventDatabase ed = new EventDatabase();
        ed.dbOp = 0;
        ed.events = new ArrayList<GEvent>();
        ed.events.add(event);
        return ed;
    }

    public static EventDatabase inserts(List<GEvent> events) {
        EventDatabase ed = new EventDatabase();
        ed.dbOp = 0;
        ed.events = new ArrayList<GEvent>();
        ed.events.addAll(events);
        return ed;
    }

    public static EventDatabase outDated() {
        EventDatabase ed = new EventDatabase();
        ed.dbOp = 4;
        return ed;
    }

    public static EventDatabase query(int policy, int limit) {
        EventDatabase ed = new EventDatabase();
        ed.dbOp = 1;
        ed.policy = policy;
        ed.limit = limit;
        return ed;
    }

    public static EventDatabase queryAndDelete(int policy, int limit) {
        EventDatabase ed = new EventDatabase();
        ed.dbOp = 5;
        ed.policy = policy;
        ed.limit = limit;
        return ed;
    }

    public static EventDatabase delete(long lastId, int policy, String eventType) {
        EventDatabase ed = new EventDatabase();
        ed.dbOp = 3;
        ed.policy = policy;
        ed.eventType = eventType;
        ed.lastId = lastId;
        return ed;
    }

    public static EventDatabase clear() {
        EventDatabase ed = new EventDatabase();
        ed.dbOp = 6;
        return ed;
    }
}

