/*
 * Decompiled with CFR 0.152.
 */
package com.growingio.android.sdk.track.log;

import android.support.annotation.Nullable;
import com.growingio.android.sdk.track.log.CacheLogger;
import com.growingio.android.sdk.track.log.ErrorLogger;
import com.growingio.android.sdk.track.log.ILogger;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Logger {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final ConcurrentHashMap<String, ILogger> LOGGERS = new ConcurrentHashMap();

    private Logger() {
        throw new AssertionError((Object)"No instances.");
    }

    public static void addLogger(ILogger logger) {
        LOGGERS.put(logger.getType(), logger);
    }

    public static void removeLogger(ILogger logger) {
        LOGGERS.remove(logger.getType());
    }

    @Nullable
    public static ILogger getLogger(String loggerType) {
        return LOGGERS.get(loggerType);
    }

    public static void v(String tag, String message, Object ... args) {
        for (Map.Entry<String, ILogger> entry : LOGGERS.entrySet()) {
            entry.getValue().v(tag, message, args);
        }
    }

    public static void v(String tag, Throwable t, String message, Object ... args) {
        for (Map.Entry<String, ILogger> entry : LOGGERS.entrySet()) {
            entry.getValue().v(tag, t, message, args);
        }
    }

    public static void v(String tag, Throwable t) {
        for (Map.Entry<String, ILogger> entry : LOGGERS.entrySet()) {
            entry.getValue().v(tag, t);
        }
    }

    public static void d(String tag, String message, Object ... args) {
        for (Map.Entry<String, ILogger> entry : LOGGERS.entrySet()) {
            entry.getValue().d(tag, message, args);
        }
    }

    public static void d(String tag, Throwable t, String message, Object ... args) {
        for (Map.Entry<String, ILogger> entry : LOGGERS.entrySet()) {
            entry.getValue().d(tag, t, message, args);
        }
    }

    public static void d(String tag, Throwable t) {
        for (Map.Entry<String, ILogger> entry : LOGGERS.entrySet()) {
            entry.getValue().d(tag, t);
        }
    }

    public static void i(String tag, String message, Object ... args) {
        for (Map.Entry<String, ILogger> entry : LOGGERS.entrySet()) {
            entry.getValue().i(tag, message, args);
        }
    }

    public static void i(String tag, Throwable t, String message, Object ... args) {
        for (Map.Entry<String, ILogger> entry : LOGGERS.entrySet()) {
            entry.getValue().i(tag, t, message, args);
        }
    }

    public static void i(String tag, Throwable t) {
        for (Map.Entry<String, ILogger> entry : LOGGERS.entrySet()) {
            entry.getValue().i(tag, t);
        }
    }

    public static void w(String tag, String message, Object ... args) {
        for (Map.Entry<String, ILogger> entry : LOGGERS.entrySet()) {
            entry.getValue().w(tag, message, args);
        }
    }

    public static void w(String tag, Throwable t, String message, Object ... args) {
        for (Map.Entry<String, ILogger> entry : LOGGERS.entrySet()) {
            entry.getValue().w(tag, t, message, args);
        }
    }

    public static void w(String tag, Throwable t) {
        for (Map.Entry<String, ILogger> entry : LOGGERS.entrySet()) {
            entry.getValue().w(tag, t);
        }
    }

    public static void e(String tag, String message, Object ... args) {
        for (Map.Entry<String, ILogger> entry : LOGGERS.entrySet()) {
            entry.getValue().e(tag, message, args);
        }
    }

    public static void e(String tag, Throwable t, String message, Object ... args) {
        for (Map.Entry<String, ILogger> entry : LOGGERS.entrySet()) {
            entry.getValue().e(tag, t, message, args);
        }
    }

    public static void e(String tag, Throwable t) {
        for (Map.Entry<String, ILogger> entry : LOGGERS.entrySet()) {
            entry.getValue().e(tag, t);
        }
    }

    public static void wtf(String tag, String message, Object ... args) {
        for (Map.Entry<String, ILogger> entry : LOGGERS.entrySet()) {
            entry.getValue().wtf(tag, message, args);
        }
    }

    public static void wtf(String tag, Throwable t, String message, Object ... args) {
        for (Map.Entry<String, ILogger> entry : LOGGERS.entrySet()) {
            entry.getValue().wtf(tag, t, message, args);
        }
    }

    public static void wtf(String tag, Throwable t) {
        for (Map.Entry<String, ILogger> entry : LOGGERS.entrySet()) {
            entry.getValue().wtf(tag, t);
        }
    }

    private static void printLine(String tag, boolean isTop) {
        if (isTop) {
            Logger.d(tag, "\u2554\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550", new Object[0]);
        } else {
            Logger.d(tag, "\u255a\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550", new Object[0]);
        }
    }

    private static String getLine(boolean isTop) {
        if (isTop) {
            return "\u2554\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550";
        }
        return "\u255a\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550";
    }

    public static void printJson(String tag, String headString, String jsonStr) {
        String[] lines;
        String message;
        try {
            if (jsonStr.startsWith("{")) {
                JSONObject jsonObject = new JSONObject(jsonStr);
                message = jsonObject.toString(2);
                message = message.replace("\\/", "/");
            } else if (jsonStr.startsWith("[")) {
                JSONArray jsonArray = new JSONArray(jsonStr);
                message = jsonArray.toString(2);
                message = message.replace("\\/", "/");
            } else {
                message = jsonStr;
            }
        }
        catch (JSONException e) {
            message = jsonStr;
        }
        StringBuilder beautifulMsg = new StringBuilder(Logger.getLine(true)).append(LINE_SEPARATOR);
        for (String line : lines = message.split(LINE_SEPARATOR)) {
            beautifulMsg.append("\u2551 ").append(line).append(LINE_SEPARATOR);
        }
        beautifulMsg.append(Logger.getLine(false));
        message = headString + LINE_SEPARATOR + beautifulMsg.toString();
        Logger.d(tag, message, new Object[0]);
    }

    static {
        Logger.addLogger(new ErrorLogger());
        Logger.addLogger(new CacheLogger());
    }
}

