/*
 * Decompiled with CFR 0.152.
 */
package com.growingio.android.sdk.track.log;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.growingio.android.sdk.track.log.BaseLogger;

public class DebugLogger
extends BaseLogger {
    private static final String TYPE = "Logcat";
    private static final String TAG_PREFIX = "TRACK.";
    private static final int MAX_LOG_LENGTH = 4000;

    @Override
    protected void print(int priority, @NonNull String tag, @NonNull String message, @Nullable Throwable t) {
        if (priority > 7) {
            return;
        }
        tag = TAG_PREFIX + tag;
        if (message.length() < 4000) {
            if (priority == 7) {
                Log.wtf((String)tag, (String)message);
            } else {
                Log.println((int)priority, (String)tag, (String)message);
            }
            return;
        }
        int length = message.length();
        for (int i = 0; i < length; ++i) {
            int end;
            int newline = message.indexOf(10, i);
            newline = newline != -1 ? newline : length;
            do {
                end = Math.min(newline, i + 4000);
                String part = message.substring(i, end);
                if (priority == 7) {
                    Log.wtf((String)tag, (String)part);
                    continue;
                }
                Log.println((int)priority, (String)tag, (String)part);
            } while ((i = end) < newline);
        }
    }

    @Override
    public String getType() {
        return TYPE;
    }
}

