/*
 * Decompiled with CFR 0.152.
 */
package com.growingio.android.sdk.track.log;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Queue;

public class CircularFifoQueue<E>
extends AbstractCollection<E>
implements Queue<E>,
Serializable {
    private static final long serialVersionUID = -8423413834657610406L;
    private transient E[] mElements;
    private transient int mStart = 0;
    private transient int mEnd = 0;
    private transient boolean mFull = false;
    private final int mMaxElements;

    public CircularFifoQueue() {
        this(32);
    }

    public CircularFifoQueue(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("The size must be greater than 0");
        }
        this.mElements = new Object[size];
        this.mMaxElements = this.mElements.length;
    }

    public CircularFifoQueue(Collection<? extends E> coll) {
        this(coll.size());
        this.addAll(coll);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeInt(this.size());
        for (E e : this) {
            out.writeObject(e);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.mElements = new Object[this.mMaxElements];
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            this.mElements[i] = in.readObject();
        }
        this.mStart = 0;
        this.mFull = size == this.mMaxElements;
        this.mEnd = this.mFull ? 0 : size;
    }

    @Override
    public int size() {
        int size = 0;
        size = this.mEnd < this.mStart ? this.mMaxElements - this.mStart + this.mEnd : (this.mEnd == this.mStart ? (this.mFull ? this.mMaxElements : 0) : this.mEnd - this.mStart);
        return size;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean ismFull() {
        return false;
    }

    public boolean isAtFullCapacity() {
        return this.size() == this.mMaxElements;
    }

    public int maxSize() {
        return this.mMaxElements;
    }

    @Override
    public void clear() {
        this.mFull = false;
        this.mStart = 0;
        this.mEnd = 0;
        Arrays.fill(this.mElements, null);
    }

    @Override
    public boolean add(E element) {
        if (null == element) {
            throw new NullPointerException("Attempted to add null object to queue");
        }
        if (this.isAtFullCapacity()) {
            this.remove();
        }
        this.mElements[this.mEnd++] = element;
        if (this.mEnd >= this.mMaxElements) {
            this.mEnd = 0;
        }
        if (this.mEnd == this.mStart) {
            this.mFull = true;
        }
        return true;
    }

    public E get(int index) {
        int sz = this.size();
        if (index < 0 || index >= sz) {
            throw new NoSuchElementException(String.format("The specified index (%1$d) is outside the available range [0, %2$d)", index, sz));
        }
        int idx = (this.mStart + index) % this.mMaxElements;
        return this.mElements[idx];
    }

    @Override
    public boolean offer(E element) {
        return this.add(element);
    }

    @Override
    public E poll() {
        if (this.isEmpty()) {
            return null;
        }
        return this.remove();
    }

    @Override
    public E element() {
        if (this.isEmpty()) {
            throw new NoSuchElementException("queue is empty");
        }
        return this.peek();
    }

    @Override
    public E peek() {
        if (this.isEmpty()) {
            return null;
        }
        return this.mElements[this.mStart];
    }

    @Override
    public E remove() {
        if (this.isEmpty()) {
            throw new NoSuchElementException("queue is empty");
        }
        E element = this.mElements[this.mStart];
        if (null != element) {
            this.mElements[this.mStart++] = null;
            if (this.mStart >= this.mMaxElements) {
                this.mStart = 0;
            }
            this.mFull = false;
        }
        return element;
    }

    private int increment(int index) {
        if (++index >= this.mMaxElements) {
            index = 0;
        }
        return index;
    }

    private int decrement(int index) {
        if (--index < 0) {
            index = this.mMaxElements - 1;
        }
        return index;
    }

    @Override
    public Iterator<E> iterator() {
        return new Iterator<E>(){
            private int mIndex;
            private int mLastReturnedIndex;
            private boolean mIsFirst;
            {
                this.mIndex = CircularFifoQueue.this.mStart;
                this.mLastReturnedIndex = -1;
                this.mIsFirst = CircularFifoQueue.this.mFull;
            }

            @Override
            public boolean hasNext() {
                return this.mIsFirst || this.mIndex != CircularFifoQueue.this.mEnd;
            }

            @Override
            public E next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.mIsFirst = false;
                this.mLastReturnedIndex = this.mIndex;
                this.mIndex = CircularFifoQueue.this.increment(this.mIndex);
                return CircularFifoQueue.this.mElements[this.mLastReturnedIndex];
            }

            @Override
            public void remove() {
                if (this.mLastReturnedIndex == -1) {
                    throw new IllegalStateException();
                }
                if (this.mLastReturnedIndex == CircularFifoQueue.this.mStart) {
                    CircularFifoQueue.this.remove();
                    this.mLastReturnedIndex = -1;
                    return;
                }
                int pos = this.mLastReturnedIndex + 1;
                if (CircularFifoQueue.this.mStart < this.mLastReturnedIndex && pos < CircularFifoQueue.this.mEnd) {
                    System.arraycopy(CircularFifoQueue.this.mElements, pos, CircularFifoQueue.this.mElements, this.mLastReturnedIndex, CircularFifoQueue.this.mEnd - pos);
                } else {
                    while (pos != CircularFifoQueue.this.mEnd) {
                        if (pos >= CircularFifoQueue.this.mMaxElements) {
                            ((CircularFifoQueue)CircularFifoQueue.this).mElements[pos - 1] = CircularFifoQueue.this.mElements[0];
                            pos = 0;
                            continue;
                        }
                        ((CircularFifoQueue)CircularFifoQueue.this).mElements[((CircularFifoQueue)CircularFifoQueue.this).decrement((int)pos)] = CircularFifoQueue.this.mElements[pos];
                        pos = CircularFifoQueue.this.increment(pos);
                    }
                }
                this.mLastReturnedIndex = -1;
                CircularFifoQueue.this.mEnd = CircularFifoQueue.this.decrement(CircularFifoQueue.this.mEnd);
                ((CircularFifoQueue)CircularFifoQueue.this).mElements[((CircularFifoQueue)CircularFifoQueue.this).mEnd] = null;
                CircularFifoQueue.this.mFull = false;
                this.mIndex = CircularFifoQueue.this.decrement(this.mIndex);
            }
        };
    }
}

