/*
 * Decompiled with CFR 0.152.
 */
package com.growingio.android.sdk.track.log;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.growingio.android.sdk.track.log.BaseLogger;
import com.growingio.android.sdk.track.log.CircularFifoQueue;
import com.growingio.android.sdk.track.log.LogItem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class CacheLogger
extends BaseLogger {
    public static final String TYPE = "CacheLogger";
    private final CircularFifoQueue<LogItem> mCacheLogs = new CircularFifoQueue(100);

    @Override
    protected synchronized void print(int priority, @NonNull String tag, @NonNull String message, @Nullable Throwable t) {
        this.mCacheLogs.add(new LogItem.Builder().setPriority(priority).setTag(tag).setMessage(message).setThrowable(t).setTimeStamp(System.currentTimeMillis()).build());
    }

    @Override
    public String getType() {
        return TYPE;
    }

    public synchronized List<LogItem> getCacheLogsAndClear() {
        if (this.mCacheLogs.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<LogItem> copyList = new ArrayList<LogItem>(this.mCacheLogs.size());
        copyList.addAll(this.mCacheLogs);
        this.mCacheLogs.clear();
        return copyList;
    }

    public synchronized List<LogItem> getCacheLogs() {
        if (this.mCacheLogs.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<LogItem> copyList = new ArrayList<LogItem>(this.mCacheLogs.size());
        copyList.addAll(this.mCacheLogs);
        return copyList;
    }
}

