/*
 * Decompiled with CFR 0.152.
 */
package com.growingio.android.sdk.track.log;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.growingio.android.sdk.track.log.ILogger;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;

public abstract class BaseLogger
implements ILogger {
    @Override
    public void v(String tag, String message, Object ... args) {
        this.prepareLog(2, tag, null, message, args);
    }

    @Override
    public void v(String tag, Throwable t, String message, Object ... args) {
        this.prepareLog(2, tag, t, message, args);
    }

    @Override
    public void v(String tag, Throwable t) {
        this.prepareLog(2, tag, t, null, new Object[0]);
    }

    @Override
    public void d(String tag, String message, Object ... args) {
        this.prepareLog(3, tag, null, message, args);
    }

    @Override
    public void d(String tag, Throwable t, String message, Object ... args) {
        this.prepareLog(3, tag, t, message, args);
    }

    @Override
    public void d(String tag, Throwable t) {
        this.prepareLog(3, tag, t, null, new Object[0]);
    }

    @Override
    public void i(String tag, String message, Object ... args) {
        this.prepareLog(4, tag, null, message, args);
    }

    @Override
    public void i(String tag, Throwable t, String message, Object ... args) {
        this.prepareLog(4, tag, t, message, args);
    }

    @Override
    public void i(String tag, Throwable t) {
        this.prepareLog(4, tag, t, null, new Object[0]);
    }

    @Override
    public void w(String tag, String message, Object ... args) {
        this.prepareLog(5, tag, null, message, args);
    }

    @Override
    public void w(String tag, Throwable t, String message, Object ... args) {
        this.prepareLog(5, tag, t, message, args);
    }

    @Override
    public void w(String tag, Throwable t) {
        this.prepareLog(5, tag, t, null, new Object[0]);
    }

    @Override
    public void e(String tag, String message, Object ... args) {
        this.prepareLog(6, tag, null, message, args);
    }

    @Override
    public void e(String tag, Throwable t, String message, Object ... args) {
        this.prepareLog(6, tag, t, message, args);
    }

    @Override
    public void e(String tag, Throwable t) {
        this.prepareLog(6, tag, t, null, new Object[0]);
    }

    @Override
    public void wtf(String tag, String message, Object ... args) {
        this.prepareLog(7, tag, null, message, args);
    }

    @Override
    public void wtf(String tag, Throwable t, String message, Object ... args) {
        this.prepareLog(7, tag, t, message, args);
    }

    @Override
    public void wtf(String tag, Throwable t) {
        this.prepareLog(7, tag, t, null, new Object[0]);
    }

    private void prepareLog(int priority, String tag, Throwable t, String message, Object ... args) {
        if (tag == null || tag.length() == 0) {
            return;
        }
        if (message != null && message.length() == 0) {
            message = null;
        }
        if (message == null) {
            if (t == null) {
                return;
            }
            message = this.getStackTraceString(t);
        } else {
            if (args != null && args.length > 0) {
                message = this.formatMessage(message, args);
            }
            if (t != null) {
                message = message + "\n" + this.getStackTraceString(t);
            }
        }
        this.print(priority, tag, message, t);
    }

    private String formatMessage(@NonNull String message, @NonNull Object[] args) {
        try {
            return String.format(message, args);
        }
        catch (Exception exception) {
            return message;
        }
    }

    private String getStackTraceString(Throwable t) {
        StringWriter sw = new StringWriter(256);
        PrintWriter pw = new PrintWriter((Writer)sw, false);
        t.printStackTrace(pw);
        pw.flush();
        return sw.toString();
    }

    protected abstract void print(int var1, @NonNull String var2, @NonNull String var3, @Nullable Throwable var4);
}

