/*
 * Decompiled with CFR 0.152.
 */
package com.growingio.android.sdk.track.listener.event;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import java.lang.ref.WeakReference;

public class ActivityLifecycleEvent {
    public final EVENT_TYPE eventType;
    private WeakReference<Activity> mActivityWeakReference;
    private WeakReference<Bundle> mBundleWeakReference;
    private WeakReference<Intent> mIntentWeakReference;

    private ActivityLifecycleEvent(Activity activity, EVENT_TYPE eventType) {
        this.mActivityWeakReference = new WeakReference<Activity>(activity);
        this.eventType = eventType;
    }

    private ActivityLifecycleEvent(Activity activity, EVENT_TYPE eventType, Bundle outState) {
        this.mActivityWeakReference = new WeakReference<Activity>(activity);
        this.mBundleWeakReference = new WeakReference<Bundle>(outState);
        this.eventType = eventType;
    }

    private ActivityLifecycleEvent(Activity activity, EVENT_TYPE eventType, Intent intent) {
        this.mActivityWeakReference = new WeakReference<Activity>(activity);
        this.mIntentWeakReference = new WeakReference<Intent>(intent);
        this.eventType = eventType;
    }

    public static ActivityLifecycleEvent createOnCreatedEvent(Activity activity, Bundle outState) {
        return new ActivityLifecycleEvent(activity, EVENT_TYPE.ON_CREATED, outState);
    }

    public static ActivityLifecycleEvent createOnStartedEvent(Activity activity) {
        return new ActivityLifecycleEvent(activity, EVENT_TYPE.ON_STARTED);
    }

    public static ActivityLifecycleEvent createOnResumedEvent(Activity activity) {
        return new ActivityLifecycleEvent(activity, EVENT_TYPE.ON_RESUMED);
    }

    public static ActivityLifecycleEvent createOnNewIntentEvent(Activity activity, Intent intent) {
        return new ActivityLifecycleEvent(activity, EVENT_TYPE.ON_NEW_INTENT, intent);
    }

    public static ActivityLifecycleEvent createOnPausedEvent(Activity activity) {
        return new ActivityLifecycleEvent(activity, EVENT_TYPE.ON_PAUSED);
    }

    public static ActivityLifecycleEvent createOnSaveInstanceStateEvent(Activity activity, Bundle outState) {
        return new ActivityLifecycleEvent(activity, EVENT_TYPE.ON_SAVE_INSTANCE_STATE, outState);
    }

    public static ActivityLifecycleEvent createOnStoppedEvent(Activity activity) {
        return new ActivityLifecycleEvent(activity, EVENT_TYPE.ON_STOPPED);
    }

    public static ActivityLifecycleEvent createOnDestroyedEvent(Activity activity) {
        return new ActivityLifecycleEvent(activity, EVENT_TYPE.ON_DESTROYED);
    }

    public Activity getActivity() {
        if (this.mActivityWeakReference != null) {
            return (Activity)this.mActivityWeakReference.get();
        }
        return null;
    }

    public Bundle getBundle() {
        if (this.mBundleWeakReference != null) {
            return (Bundle)this.mBundleWeakReference.get();
        }
        return null;
    }

    public Intent getIntent() {
        if (this.mIntentWeakReference != null && this.mIntentWeakReference.get() != null) {
            return (Intent)this.mIntentWeakReference.get();
        }
        Activity activity = this.getActivity();
        if (activity != null) {
            return activity.getIntent();
        }
        return null;
    }

    public static enum EVENT_TYPE {
        ON_CREATED,
        ON_STARTED,
        ON_RESUMED,
        ON_NEW_INTENT,
        ON_PAUSED,
        ON_SAVE_INSTANCE_STATE,
        ON_STOPPED,
        ON_DESTROYED;

    }
}

