/*
 * Decompiled with CFR 0.152.
 */
package com.growingio.android.sdk.track.listener;

import com.growingio.android.sdk.track.log.Logger;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;

public abstract class ListenerContainer<L, A> {
    private static final String TAG = "ListenerContainer";
    private final List<L> mListeners = new ArrayList<L>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(L listener) {
        List<L> list = this.mListeners;
        synchronized (list) {
            boolean needsAdd = true;
            Iterator<L> refIter = this.mListeners.iterator();
            while (refIter.hasNext()) {
                try {
                    L storedListener = refIter.next();
                    if (null == storedListener) {
                        refIter.remove();
                        continue;
                    }
                    if (storedListener != listener) continue;
                    needsAdd = false;
                }
                catch (ConcurrentModificationException e) {
                    Logger.e(TAG, "Please avoid call register method in dispatchActions", new Object[0]);
                    throw e;
                }
            }
            if (needsAdd) {
                this.mListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister(L listener) {
        List<L> list = this.mListeners;
        synchronized (list) {
            Iterator<L> refIter = this.mListeners.iterator();
            while (refIter.hasNext()) {
                L storedListener = refIter.next();
                if (null == storedListener) {
                    refIter.remove();
                    continue;
                }
                if (storedListener != listener) continue;
                refIter.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dispatchActions(A action) {
        List<L> list = this.mListeners;
        synchronized (list) {
            Iterator<L> refIter = this.mListeners.iterator();
            while (refIter.hasNext()) {
                try {
                    L listener = refIter.next();
                    if (null == listener) {
                        refIter.remove();
                        continue;
                    }
                    this.singleAction(listener, action);
                }
                catch (ConcurrentModificationException e) {
                    Logger.e(TAG, "Please avoid call register method in dispatchActions", new Object[0]);
                    throw e;
                }
                catch (Exception e) {
                    Logger.e(TAG, e);
                }
            }
        }
    }

    protected int getListenerCount() {
        return this.mListeners.size();
    }

    protected abstract void singleAction(L var1, A var2);
}

